package com.js.dal.dao.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.base.IBaseMapper;
import com.js.dal.dao.model.IBaseModel;
import com.js.dal.dao.service.IBaseService;
import org.springframework.beans.factory.annotation.Autowired;
import tk.mybatis.mapper.entity.Example;

import java.lang.reflect.ParameterizedType;
import java.util.Date;
import java.util.List;

/**
 * @ClassName: IBaseServiceImpl
 * @Description: 通用service实现
 * @Author: yjzhao
 * @Create: 2019-05-21  18:11
 **/
public class IBaseServiceImpl<E extends IBaseModel> implements IBaseService<E> {
    @Autowired
    protected IBaseMapper<E> iBaseMapper;

    public IBaseMapper<E> getiBaseMapper() {
        return iBaseMapper;
    }

    protected Class<E> poType;

    public IBaseServiceImpl() {
        ParameterizedType pt = (ParameterizedType) this.getClass().getGenericSuperclass();
        poType = (Class<E>) pt.getActualTypeArguments()[0];
    }

    @Override
    public int insertSelective(E record) {
        Date currDate = new Date();
        if (StrUtil.isEmpty(record.getId())) {
            record.setId(IdUtil.simpleUUID());
        }
        String id =  record.getId();
        if (StrUtil.isEmpty(record.getCreateId())) {
            record.setCreateId(id);
        }
        if (record.getCreateDts() == null) {
            record.setCreateDts(currDate);
        }
        if (record.getUpdateDts() == null) {
            record.setUpdateDts(currDate);
        }
        return iBaseMapper.insertSelective(record);
    }

    @Override
    public int updateByExampleSelective(E record, Example example) {
        Date currDate = new Date();
        if (record.getUpdateDts() == null) {
            record.setUpdateDts(currDate);
        }
        if (record.getUpdateId() == null) {
            record.setUpdateId(record.getUpdateId());
        }
        return iBaseMapper.updateByExampleSelective(record, example);
    }
}
