package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "platform_statistics_by_shop")
public class PlatformStatisticsByStore extends IBaseModel implements Serializable {
    /**
     * 店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 月均销售额
     */
    @Column(name = "monthly_sale")
    private BigDecimal monthlySale;

    /**
     * 月均销售占比
     */
    @Column(name = "monthly_sale_ratio")
    private BigDecimal monthlySaleRatio;

    /**
     * 入账金额
     */
    private BigDecimal income;

    /**
     * 近 12 个月的月均入账金额，如果不足 12 个月会以现有的完整月份进行平均。
     */
    @Column(name = "monthly_income")
    private BigDecimal monthlyIncome;

    /**
     * 笔均入账金额
     */
    @Column(name = "average_income")
    private BigDecimal averageIncome;

    /**
     * 近一个月入账金额环比增长率
     */
    @Column(name = "income_chain_rate")
    private BigDecimal incomeChainRate;

    /**
     * 入账金额同比增长率
     */
    @Column(name = "income_growth_rate_on_year")
    private BigDecimal incomeGrowthRateOnYear;

    /**
     * 客单价
     */
    @Column(name = "per_customer_transaction")
    private BigDecimal perCustomerTransaction;

    /**
     * 客单价同比增长率
     */
    @Column(name = "per_cus_trans_growth_rate_on_year")
    private BigDecimal perCusTransGrowthRateOnYear;

    /**
     * 月订单量
     */
    @Column(name = "monthly_order_num")
    private BigDecimal monthlyOrderNum;

    /**
     * 退款率
     */
    @Column(name = "refund_rate")
    private BigDecimal refundRate;

    /**
     * 退款率同比增长率
     */
    @Column(name = "refund_growth_rate_on_year")
    private BigDecimal refundGrowthRateOnYear;

    /**
     * 退款率环比波动率
     */
    @Column(name = "refund_chain_rate")
    private BigDecimal refundChainRate;

    /**
     * 在售商品数量
     */
    @Column(name = "available_product_num")
    private BigDecimal availableProductNum;

    /**
     * 在售商品数量环比波动率
     */
    @Column(name = "available_product_num_chain_rate")
    private BigDecimal availableProductNumChainRate;

    /**
     * 销售额前10名商品占比
     */
    @Column(name = "sales_top_ten_ratio")
    private BigDecimal salesTopTenRatio;

    /**
     * 销售额前3名商品占比
     */
    @Column(name = "sales_top_three_ratio")
    private BigDecimal salesTopThreeRatio;

    /**
     * 近一个月入账金额与前3个月平均入账金额比例
     */
    @Column(name = "income_three_ratio")
    private BigDecimal incomeThreeRatio;

    /**
     * 近一个月入账金额与前6个月平均入账金额比例
     */
    @Column(name = "income_six_ratio")
    private BigDecimal incomeSixRatio;

    /**
     * 绑定回款时间，单位为月
     */
    @Column(name = "bind_time")
    private BigDecimal bindTime;

    /**
     * 统计时间
     */
    @Column(name = "statistics_time")
    private Date statisticsTime;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PlatformStatisticsByStore other = (PlatformStatisticsByStore) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getMonthlySale() == null ? other.getMonthlySale() == null : this.getMonthlySale().equals(other.getMonthlySale()))
            && (this.getMonthlySaleRatio() == null ? other.getMonthlySaleRatio() == null : this.getMonthlySaleRatio().equals(other.getMonthlySaleRatio()))
            && (this.getIncome() == null ? other.getIncome() == null : this.getIncome().equals(other.getIncome()))
            && (this.getMonthlyIncome() == null ? other.getMonthlyIncome() == null : this.getMonthlyIncome().equals(other.getMonthlyIncome()))
            && (this.getAverageIncome() == null ? other.getAverageIncome() == null : this.getAverageIncome().equals(other.getAverageIncome()))
            && (this.getIncomeChainRate() == null ? other.getIncomeChainRate() == null : this.getIncomeChainRate().equals(other.getIncomeChainRate()))
            && (this.getIncomeGrowthRateOnYear() == null ? other.getIncomeGrowthRateOnYear() == null : this.getIncomeGrowthRateOnYear().equals(other.getIncomeGrowthRateOnYear()))
            && (this.getPerCustomerTransaction() == null ? other.getPerCustomerTransaction() == null : this.getPerCustomerTransaction().equals(other.getPerCustomerTransaction()))
            && (this.getPerCusTransGrowthRateOnYear() == null ? other.getPerCusTransGrowthRateOnYear() == null : this.getPerCusTransGrowthRateOnYear().equals(other.getPerCusTransGrowthRateOnYear()))
            && (this.getMonthlyOrderNum() == null ? other.getMonthlyOrderNum() == null : this.getMonthlyOrderNum().equals(other.getMonthlyOrderNum()))
            && (this.getRefundRate() == null ? other.getRefundRate() == null : this.getRefundRate().equals(other.getRefundRate()))
            && (this.getRefundGrowthRateOnYear() == null ? other.getRefundGrowthRateOnYear() == null : this.getRefundGrowthRateOnYear().equals(other.getRefundGrowthRateOnYear()))
            && (this.getRefundChainRate() == null ? other.getRefundChainRate() == null : this.getRefundChainRate().equals(other.getRefundChainRate()))
            && (this.getAvailableProductNum() == null ? other.getAvailableProductNum() == null : this.getAvailableProductNum().equals(other.getAvailableProductNum()))
            && (this.getAvailableProductNumChainRate() == null ? other.getAvailableProductNumChainRate() == null : this.getAvailableProductNumChainRate().equals(other.getAvailableProductNumChainRate()))
            && (this.getSalesTopTenRatio() == null ? other.getSalesTopTenRatio() == null : this.getSalesTopTenRatio().equals(other.getSalesTopTenRatio()))
            && (this.getSalesTopThreeRatio() == null ? other.getSalesTopThreeRatio() == null : this.getSalesTopThreeRatio().equals(other.getSalesTopThreeRatio()))
            && (this.getIncomeThreeRatio() == null ? other.getIncomeThreeRatio() == null : this.getIncomeThreeRatio().equals(other.getIncomeThreeRatio()))
            && (this.getIncomeSixRatio() == null ? other.getIncomeSixRatio() == null : this.getIncomeSixRatio().equals(other.getIncomeSixRatio()))
            && (this.getBindTime() == null ? other.getBindTime() == null : this.getBindTime().equals(other.getBindTime()))
            && (this.getStatisticsTime() == null ? other.getStatisticsTime() == null : this.getStatisticsTime().equals(other.getStatisticsTime()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getMonthlySale() == null) ? 0 : getMonthlySale().hashCode());
        result = prime * result + ((getMonthlySaleRatio() == null) ? 0 : getMonthlySaleRatio().hashCode());
        result = prime * result + ((getIncome() == null) ? 0 : getIncome().hashCode());
        result = prime * result + ((getMonthlyIncome() == null) ? 0 : getMonthlyIncome().hashCode());
        result = prime * result + ((getAverageIncome() == null) ? 0 : getAverageIncome().hashCode());
        result = prime * result + ((getIncomeChainRate() == null) ? 0 : getIncomeChainRate().hashCode());
        result = prime * result + ((getIncomeGrowthRateOnYear() == null) ? 0 : getIncomeGrowthRateOnYear().hashCode());
        result = prime * result + ((getPerCustomerTransaction() == null) ? 0 : getPerCustomerTransaction().hashCode());
        result = prime * result + ((getPerCusTransGrowthRateOnYear() == null) ? 0 : getPerCusTransGrowthRateOnYear().hashCode());
        result = prime * result + ((getMonthlyOrderNum() == null) ? 0 : getMonthlyOrderNum().hashCode());
        result = prime * result + ((getRefundRate() == null) ? 0 : getRefundRate().hashCode());
        result = prime * result + ((getRefundGrowthRateOnYear() == null) ? 0 : getRefundGrowthRateOnYear().hashCode());
        result = prime * result + ((getRefundChainRate() == null) ? 0 : getRefundChainRate().hashCode());
        result = prime * result + ((getAvailableProductNum() == null) ? 0 : getAvailableProductNum().hashCode());
        result = prime * result + ((getAvailableProductNumChainRate() == null) ? 0 : getAvailableProductNumChainRate().hashCode());
        result = prime * result + ((getSalesTopTenRatio() == null) ? 0 : getSalesTopTenRatio().hashCode());
        result = prime * result + ((getSalesTopThreeRatio() == null) ? 0 : getSalesTopThreeRatio().hashCode());
        result = prime * result + ((getIncomeThreeRatio() == null) ? 0 : getIncomeThreeRatio().hashCode());
        result = prime * result + ((getIncomeSixRatio() == null) ? 0 : getIncomeSixRatio().hashCode());
        result = prime * result + ((getBindTime() == null) ? 0 : getBindTime().hashCode());
        result = prime * result + ((getStatisticsTime() == null) ? 0 : getStatisticsTime().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}