package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "platform_statistics_by_kyc")
public class PlatformStatisticsByKyc extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    @Column(name = "half_year_sale_ratio")
    private BigDecimal halfYearSaleRatio;

    /**
     * 亚马逊美国店铺数量占比
     */
    @Column(name = "amazonusshop_ratio")
    private BigDecimal amazonusshopRatio;

    /**
     * 亚马逊美国店铺销售额占比
     */
    @Column(name = "amazonussale_ratio")
    private BigDecimal amazonussaleRatio;

    /**
     * 月均销售额
     */
    @Column(name = "monthly_sale")
    private BigDecimal monthlySale;

    /**
     * 入账金额
     */
    private BigDecimal income;

    /**
     * 入账环比增涨率
     */
    @Column(name = "income_chain_rate")
    private BigDecimal incomeChainRate;

    /**
     * 月均入账金额
     */
    @Column(name = "monthly_income")
    private BigDecimal monthlyIncome;

    /**
     * 近一个月入账金额与前3个月平均入账金额比例
     */
    @Column(name = "income_three_ratio")
    private BigDecimal incomeThreeRatio;

    /**
     * 近一个月入账金额与前6个月平均入账金额比例
     */
    @Column(name = "income_six_ratio")
    private BigDecimal incomeSixRatio;

    /**
     * 入账金额同比增长率
     */
    @Column(name = "income_growth_rate_on_year")
    private BigDecimal incomeGrowthRateOnYear;

    /**
     * 客单价
     */
    @Column(name = "per_customer_transaction")
    private BigDecimal perCustomerTransaction;

    /**
     * 客单价同比增长率
     */
    @Column(name = "per_cus_trans_growth_rate_on_year")
    private BigDecimal perCusTransGrowthRateOnYear;

    /**
     * 月订单量
     */
    @Column(name = "monthly_order_num")
    private BigDecimal monthlyOrderNum;

    /**
     * 月均退款率
     */
    @Column(name = "monthly_refund_rate")
    private BigDecimal monthlyRefundRate;

    /**
     * 退款率同比增长率
     */
    @Column(name = "monthly_refund_growth_rate_on_year")
    private BigDecimal monthlyRefundGrowthRateOnYear;

    /**
     * 在售商品数量
     */
    @Column(name = "available_product_num")
    private BigDecimal availableProductNum;

    /**
     * 统计时间
     */
    @Column(name = "statistics_time")
    private Date statisticsTime;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        PlatformStatisticsByKyc other = (PlatformStatisticsByKyc) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getHalfYearSaleRatio() == null ? other.getHalfYearSaleRatio() == null : this.getHalfYearSaleRatio().equals(other.getHalfYearSaleRatio()))
            && (this.getAmazonusshopRatio() == null ? other.getAmazonusshopRatio() == null : this.getAmazonusshopRatio().equals(other.getAmazonusshopRatio()))
            && (this.getAmazonussaleRatio() == null ? other.getAmazonussaleRatio() == null : this.getAmazonussaleRatio().equals(other.getAmazonussaleRatio()))
            && (this.getMonthlySale() == null ? other.getMonthlySale() == null : this.getMonthlySale().equals(other.getMonthlySale()))
            && (this.getIncome() == null ? other.getIncome() == null : this.getIncome().equals(other.getIncome()))
            && (this.getIncomeChainRate() == null ? other.getIncomeChainRate() == null : this.getIncomeChainRate().equals(other.getIncomeChainRate()))
            && (this.getMonthlyIncome() == null ? other.getMonthlyIncome() == null : this.getMonthlyIncome().equals(other.getMonthlyIncome()))
            && (this.getIncomeThreeRatio() == null ? other.getIncomeThreeRatio() == null : this.getIncomeThreeRatio().equals(other.getIncomeThreeRatio()))
            && (this.getIncomeSixRatio() == null ? other.getIncomeSixRatio() == null : this.getIncomeSixRatio().equals(other.getIncomeSixRatio()))
            && (this.getIncomeGrowthRateOnYear() == null ? other.getIncomeGrowthRateOnYear() == null : this.getIncomeGrowthRateOnYear().equals(other.getIncomeGrowthRateOnYear()))
            && (this.getPerCustomerTransaction() == null ? other.getPerCustomerTransaction() == null : this.getPerCustomerTransaction().equals(other.getPerCustomerTransaction()))
            && (this.getPerCusTransGrowthRateOnYear() == null ? other.getPerCusTransGrowthRateOnYear() == null : this.getPerCusTransGrowthRateOnYear().equals(other.getPerCusTransGrowthRateOnYear()))
            && (this.getMonthlyOrderNum() == null ? other.getMonthlyOrderNum() == null : this.getMonthlyOrderNum().equals(other.getMonthlyOrderNum()))
            && (this.getMonthlyRefundRate() == null ? other.getMonthlyRefundRate() == null : this.getMonthlyRefundRate().equals(other.getMonthlyRefundRate()))
            && (this.getMonthlyRefundGrowthRateOnYear() == null ? other.getMonthlyRefundGrowthRateOnYear() == null : this.getMonthlyRefundGrowthRateOnYear().equals(other.getMonthlyRefundGrowthRateOnYear()))
            && (this.getAvailableProductNum() == null ? other.getAvailableProductNum() == null : this.getAvailableProductNum().equals(other.getAvailableProductNum()))
            && (this.getStatisticsTime() == null ? other.getStatisticsTime() == null : this.getStatisticsTime().equals(other.getStatisticsTime()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getHalfYearSaleRatio() == null) ? 0 : getHalfYearSaleRatio().hashCode());
        result = prime * result + ((getAmazonusshopRatio() == null) ? 0 : getAmazonusshopRatio().hashCode());
        result = prime * result + ((getAmazonussaleRatio() == null) ? 0 : getAmazonussaleRatio().hashCode());
        result = prime * result + ((getMonthlySale() == null) ? 0 : getMonthlySale().hashCode());
        result = prime * result + ((getIncome() == null) ? 0 : getIncome().hashCode());
        result = prime * result + ((getIncomeChainRate() == null) ? 0 : getIncomeChainRate().hashCode());
        result = prime * result + ((getMonthlyIncome() == null) ? 0 : getMonthlyIncome().hashCode());
        result = prime * result + ((getIncomeThreeRatio() == null) ? 0 : getIncomeThreeRatio().hashCode());
        result = prime * result + ((getIncomeSixRatio() == null) ? 0 : getIncomeSixRatio().hashCode());
        result = prime * result + ((getIncomeGrowthRateOnYear() == null) ? 0 : getIncomeGrowthRateOnYear().hashCode());
        result = prime * result + ((getPerCustomerTransaction() == null) ? 0 : getPerCustomerTransaction().hashCode());
        result = prime * result + ((getPerCusTransGrowthRateOnYear() == null) ? 0 : getPerCusTransGrowthRateOnYear().hashCode());
        result = prime * result + ((getMonthlyOrderNum() == null) ? 0 : getMonthlyOrderNum().hashCode());
        result = prime * result + ((getMonthlyRefundRate() == null) ? 0 : getMonthlyRefundRate().hashCode());
        result = prime * result + ((getMonthlyRefundGrowthRateOnYear() == null) ? 0 : getMonthlyRefundGrowthRateOnYear().hashCode());
        result = prime * result + ((getAvailableProductNum() == null) ? 0 : getAvailableProductNum().hashCode());
        result = prime * result + ((getStatisticsTime() == null) ? 0 : getStatisticsTime().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}