package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_store")
public class KycStore extends IBaseModel implements Serializable {
    /**
     * 用户表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 店铺名称
     */
    @Column(name = "store_name")
    private String storeName;

    /**
     * 店铺持有人ID
     */
    @Column(name = "store_hold_person_id")
    private String storeHoldPersonId;

    /**
     * 店铺持有人名称
     */
    @Column(name = "store_hold_person_name")
    private String storeHoldPersonName;

    /**
     * 店铺所在平台CODE编码
     */
    @Column(name = "store_plateform_code")
    private String storePlateformCode;

    /**
     * 店铺所在平台名称
     */
    @Column(name = "store_plateform_name")
    private String storePlateformName;

    /**
     * 店铺所在站点CODE编码
     */
    @Column(name = "store_the_site_code")
    private String storeTheSiteCode;

    /**
     * 店铺所在站点名称
     */
    @Column(name = "store_the_site_name")
    private String storeTheSiteName;

    /**
     * 店铺情况(1-已有产品售卖,0-暂无产品售卖／暂无店铺)
     */
    @Column(name = "store_situation")
    private Boolean storeSituation;

    /**
     * 店铺网址
     */
    @Column(name = "store_url")
    private String storeUrl;

    /**
     * 预估月收款总额-单位（万美元）
     */
    @Column(name = "month_amt")
    private BigDecimal monthAmt;

    /**
     * 卖家编号
     */
    @Column(name = "sell_id")
    private String sellId;

    /**
     * MWS授权令牌
     */
    @Column(name = "mws_auth_token")
    private String mwsAuthToken;

    /**
     * 拉取亚马逊数据用的接口地址
     */
    @Column(name = "ama_service_url")
    private String amaServiceUrl;

    /**
     * 亚马逊市场 id，该地址是固定的。一个区域一个。调接口时有的会需要。
     */
    @Column(name = "ama_market_place_id")
    private String amaMarketPlaceId;

    /**
     * 授权状态：0：未授权 1：已经授权但调用失败 2:已经授权但没有确认第一笔回款 3：已授权且收到了回款 4：授权被取消
     */
    @Column(name = "auth_status")
    private Integer authStatus;

    /**
     * 确认收到第一笔回款时的绑定时间，如果用户中间解绑，时间会重置。
     */
    @Column(name = "auth_with_account_date")
    private Date authWithAccountDate;

    /**
     * 店铺状态[0:未绑定, 1:已绑定]
     */
    private Boolean status;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycStore other = (KycStore) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreName() == null ? other.getStoreName() == null : this.getStoreName().equals(other.getStoreName()))
            && (this.getStoreHoldPersonId() == null ? other.getStoreHoldPersonId() == null : this.getStoreHoldPersonId().equals(other.getStoreHoldPersonId()))
            && (this.getStoreHoldPersonName() == null ? other.getStoreHoldPersonName() == null : this.getStoreHoldPersonName().equals(other.getStoreHoldPersonName()))
            && (this.getStorePlateformCode() == null ? other.getStorePlateformCode() == null : this.getStorePlateformCode().equals(other.getStorePlateformCode()))
            && (this.getStorePlateformName() == null ? other.getStorePlateformName() == null : this.getStorePlateformName().equals(other.getStorePlateformName()))
            && (this.getStoreTheSiteCode() == null ? other.getStoreTheSiteCode() == null : this.getStoreTheSiteCode().equals(other.getStoreTheSiteCode()))
            && (this.getStoreTheSiteName() == null ? other.getStoreTheSiteName() == null : this.getStoreTheSiteName().equals(other.getStoreTheSiteName()))
            && (this.getStoreSituation() == null ? other.getStoreSituation() == null : this.getStoreSituation().equals(other.getStoreSituation()))
            && (this.getStoreUrl() == null ? other.getStoreUrl() == null : this.getStoreUrl().equals(other.getStoreUrl()))
            && (this.getMonthAmt() == null ? other.getMonthAmt() == null : this.getMonthAmt().equals(other.getMonthAmt()))
            && (this.getSellId() == null ? other.getSellId() == null : this.getSellId().equals(other.getSellId()))
            && (this.getMwsAuthToken() == null ? other.getMwsAuthToken() == null : this.getMwsAuthToken().equals(other.getMwsAuthToken()))
            && (this.getAmaServiceUrl() == null ? other.getAmaServiceUrl() == null : this.getAmaServiceUrl().equals(other.getAmaServiceUrl()))
            && (this.getAmaMarketPlaceId() == null ? other.getAmaMarketPlaceId() == null : this.getAmaMarketPlaceId().equals(other.getAmaMarketPlaceId()))
            && (this.getAuthStatus() == null ? other.getAuthStatus() == null : this.getAuthStatus().equals(other.getAuthStatus()))
            && (this.getAuthWithAccountDate() == null ? other.getAuthWithAccountDate() == null : this.getAuthWithAccountDate().equals(other.getAuthWithAccountDate()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreName() == null) ? 0 : getStoreName().hashCode());
        result = prime * result + ((getStoreHoldPersonId() == null) ? 0 : getStoreHoldPersonId().hashCode());
        result = prime * result + ((getStoreHoldPersonName() == null) ? 0 : getStoreHoldPersonName().hashCode());
        result = prime * result + ((getStorePlateformCode() == null) ? 0 : getStorePlateformCode().hashCode());
        result = prime * result + ((getStorePlateformName() == null) ? 0 : getStorePlateformName().hashCode());
        result = prime * result + ((getStoreTheSiteCode() == null) ? 0 : getStoreTheSiteCode().hashCode());
        result = prime * result + ((getStoreTheSiteName() == null) ? 0 : getStoreTheSiteName().hashCode());
        result = prime * result + ((getStoreSituation() == null) ? 0 : getStoreSituation().hashCode());
        result = prime * result + ((getStoreUrl() == null) ? 0 : getStoreUrl().hashCode());
        result = prime * result + ((getMonthAmt() == null) ? 0 : getMonthAmt().hashCode());
        result = prime * result + ((getSellId() == null) ? 0 : getSellId().hashCode());
        result = prime * result + ((getMwsAuthToken() == null) ? 0 : getMwsAuthToken().hashCode());
        result = prime * result + ((getAmaServiceUrl() == null) ? 0 : getAmaServiceUrl().hashCode());
        result = prime * result + ((getAmaMarketPlaceId() == null) ? 0 : getAmaMarketPlaceId().hashCode());
        result = prime * result + ((getAuthStatus() == null) ? 0 : getAuthStatus().hashCode());
        result = prime * result + ((getAuthWithAccountDate() == null) ? 0 : getAuthWithAccountDate().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}