package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;

import com.js.common.enums.CertiFileType;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "kyc_certi_link_file")
public class KycCertiLinkFile extends IBaseModel implements Serializable {
    /**
     * 注册表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 主表主键ID（大陆个人，大陆企业，香港个人，香港企业表主键）
     */
    @Column(name = "pri_id")
    private String priId;

    /**
     * js文件资源表主键ID
     */
    @Column(name = "comm_file_id")
    private String commFileId;

    /**
     * 存放位置
     */
    @Column(name = "file_save_path")
    private String fileSavePath;

    /**
     * 显示位置
     */
    @Column(name = "file_show_path")
    private String fileShowPath;

    /**
     * 存放名称
     */
    @Column(name = "file_save_name")
    private String fileSaveName;

    /**
     * 显示名称
     */
    @Column(name = "file_show_name")
    private String fileShowName;

    /**
     * 文件缩略图存放地址
     */
    @Column(name = "file_thumbnail_path")
    private String fileThumbnailPath;

    /**
     * 文件扩展名
     */
    @Column(name = "file_ext")
    private String fileExt;

    /**
     * 文件归类组名
     */
    @Column(name = "file_group")
    private String fileGroup;

    /**
     * 文件具体类型
     */
    @Column(name = "file_type")
    private CertiFileType fileType;

    /**
     * 是否上传到提供方sftp服务器上（0未上传，1已上传）
     */
    @Column(name = "upload_sftp_flag")
    private Boolean uploadSftpFlag;

    /**
     * 上传路径
     */
    @Column(name = "upload_dirc")
    private String uploadDirc;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        KycCertiLinkFile other = (KycCertiLinkFile) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getPriId() == null ? other.getPriId() == null : this.getPriId().equals(other.getPriId()))
            && (this.getCommFileId() == null ? other.getCommFileId() == null : this.getCommFileId().equals(other.getCommFileId()))
            && (this.getFileSavePath() == null ? other.getFileSavePath() == null : this.getFileSavePath().equals(other.getFileSavePath()))
            && (this.getFileShowPath() == null ? other.getFileShowPath() == null : this.getFileShowPath().equals(other.getFileShowPath()))
            && (this.getFileSaveName() == null ? other.getFileSaveName() == null : this.getFileSaveName().equals(other.getFileSaveName()))
            && (this.getFileShowName() == null ? other.getFileShowName() == null : this.getFileShowName().equals(other.getFileShowName()))
            && (this.getFileThumbnailPath() == null ? other.getFileThumbnailPath() == null : this.getFileThumbnailPath().equals(other.getFileThumbnailPath()))
            && (this.getFileExt() == null ? other.getFileExt() == null : this.getFileExt().equals(other.getFileExt()))
            && (this.getFileGroup() == null ? other.getFileGroup() == null : this.getFileGroup().equals(other.getFileGroup()))
            && (this.getFileType() == null ? other.getFileType() == null : this.getFileType().equals(other.getFileType()))
            && (this.getUploadSftpFlag() == null ? other.getUploadSftpFlag() == null : this.getUploadSftpFlag().equals(other.getUploadSftpFlag()))
            && (this.getUploadDirc() == null ? other.getUploadDirc() == null : this.getUploadDirc().equals(other.getUploadDirc()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getPriId() == null) ? 0 : getPriId().hashCode());
        result = prime * result + ((getCommFileId() == null) ? 0 : getCommFileId().hashCode());
        result = prime * result + ((getFileSavePath() == null) ? 0 : getFileSavePath().hashCode());
        result = prime * result + ((getFileShowPath() == null) ? 0 : getFileShowPath().hashCode());
        result = prime * result + ((getFileSaveName() == null) ? 0 : getFileSaveName().hashCode());
        result = prime * result + ((getFileShowName() == null) ? 0 : getFileShowName().hashCode());
        result = prime * result + ((getFileThumbnailPath() == null) ? 0 : getFileThumbnailPath().hashCode());
        result = prime * result + ((getFileExt() == null) ? 0 : getFileExt().hashCode());
        result = prime * result + ((getFileGroup() == null) ? 0 : getFileGroup().hashCode());
        result = prime * result + ((getFileType() == null) ? 0 : getFileType().hashCode());
        result = prime * result + ((getUploadSftpFlag() == null) ? 0 : getUploadSftpFlag().hashCode());
        result = prime * result + ((getUploadDirc() == null) ? 0 : getUploadDirc().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}