package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_sync_amazon_settlement_report")
public class JsSyncAmazonSettlementReport extends IBaseModel implements Serializable {
    /**
     * 用户主键 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 报告 id 主要用于重新同步时使用。
     */
    @Column(name = "report_id")
    private String reportId;

    /**
     * 结算报告 id
     */
    @Column(name = "settlement_id")
    private String settlementId;

    /**
     * 结算开始日期
     */
    @Column(name = "settlement_start_date")
    private Date settlementStartDate;

    /**
     * 结算结束日期
     */
    @Column(name = "settlement_end_date")
    private Date settlementEndDate;

    /**
     * 交易日期
     */
    @Column(name = "deposit_date")
    private Date depositDate;

    /**
     * 总金额
     */
    @Column(name = "total_amount")
    private BigDecimal totalAmount;

    /**
     * 币种
     */
    private String currency;

    /**
     * 交易类型
     */
    @Column(name = "transaction_type")
    private String transactionType;

    /**
     * 订单 id
     */
    @Column(name = "order_id")
    private String orderId;

    /**
     * 卖家订单 id
     */
    @Column(name = "merchant_order_id")
    private String merchantOrderId;

    /**
     * 调整 id
     */
    @Column(name = "adjustment_id")
    private String adjustmentId;

    /**
     * 运费 id
     */
    @Column(name = "shipment_id")
    private String shipmentId;

    /**
     * 市场名
     */
    @Column(name = "marketplace_name")
    private String marketplaceName;

    /**
     * 运费类型
     */
    @Column(name = "shipment_fee_type")
    private String shipmentFeeType;

    /**
     * 运费
     */
    @Column(name = "shipment_fee_amount")
    private BigDecimal shipmentFeeAmount;

    /**
     * 订单费用类型
     */
    @Column(name = "order_fee_type")
    private String orderFeeType;

    /**
     * 订单费用
     */
    @Column(name = "order_fee_amount")
    private BigDecimal orderFeeAmount;

    @Column(name = "fulfillment_id")
    private String fulfillmentId;

    /**
     * 到货时间
     */
    @Column(name = "posted_date")
    private Date postedDate;

    /**
     * 商品代码,对应商品明细中的 id
     */
    @Column(name = "order_item_code")
    private String orderItemCode;

    @Column(name = "merchant_order_item_id")
    private String merchantOrderItemId;

    /**
     * 卖家商品调整 id
     */
    @Column(name = "merchant_adjustment_item_id")
    private String merchantAdjustmentItemId;

    /**
     * 商品 sku
     */
    private String sku;

    /**
     * 商品数量
     */
    @Column(name = "quantity_purchased")
    private BigDecimal quantityPurchased;

    /**
     * 价格类型
     */
    @Column(name = "price_type")
    private String priceType;

    /**
     * 价格
     */
    @Column(name = "price_amount")
    private BigDecimal priceAmount;

    /**
     * 商品相关费用类型
     */
    @Column(name = "item_related_fee_type")
    private String itemRelatedFeeType;

    /**
     * 商品相关费用
     */
    @Column(name = "item_related_fee_amount")
    private BigDecimal itemRelatedFeeAmount;

    @Column(name = "misc_fee_amount")
    private BigDecimal miscFeeAmount;

    /**
     * 其它费用
     */
    @Column(name = "other_fee_amount")
    private BigDecimal otherFeeAmount;

    /**
     * 其它费用描述
     */
    @Column(name = "other_fee_reason_description")
    private String otherFeeReasonDescription;

    /**
     * 直接付款类型
     */
    @Column(name = "direct_payment_type")
    private String directPaymentType;

    /**
     * 直接付款
     */
    @Column(name = "direct_payment_amount")
    private BigDecimal directPaymentAmount;

    /**
     * 其它款目
     */
    @Column(name = "other_amount")
    private BigDecimal otherAmount;

    @Column(name = "statistics_time")
    private Date statisticsTime;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSyncAmazonSettlementReport other = (JsSyncAmazonSettlementReport) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getReportId() == null ? other.getReportId() == null : this.getReportId().equals(other.getReportId()))
            && (this.getSettlementId() == null ? other.getSettlementId() == null : this.getSettlementId().equals(other.getSettlementId()))
            && (this.getSettlementStartDate() == null ? other.getSettlementStartDate() == null : this.getSettlementStartDate().equals(other.getSettlementStartDate()))
            && (this.getSettlementEndDate() == null ? other.getSettlementEndDate() == null : this.getSettlementEndDate().equals(other.getSettlementEndDate()))
            && (this.getDepositDate() == null ? other.getDepositDate() == null : this.getDepositDate().equals(other.getDepositDate()))
            && (this.getTotalAmount() == null ? other.getTotalAmount() == null : this.getTotalAmount().equals(other.getTotalAmount()))
            && (this.getCurrency() == null ? other.getCurrency() == null : this.getCurrency().equals(other.getCurrency()))
            && (this.getTransactionType() == null ? other.getTransactionType() == null : this.getTransactionType().equals(other.getTransactionType()))
            && (this.getOrderId() == null ? other.getOrderId() == null : this.getOrderId().equals(other.getOrderId()))
            && (this.getMerchantOrderId() == null ? other.getMerchantOrderId() == null : this.getMerchantOrderId().equals(other.getMerchantOrderId()))
            && (this.getAdjustmentId() == null ? other.getAdjustmentId() == null : this.getAdjustmentId().equals(other.getAdjustmentId()))
            && (this.getShipmentId() == null ? other.getShipmentId() == null : this.getShipmentId().equals(other.getShipmentId()))
            && (this.getMarketplaceName() == null ? other.getMarketplaceName() == null : this.getMarketplaceName().equals(other.getMarketplaceName()))
            && (this.getShipmentFeeType() == null ? other.getShipmentFeeType() == null : this.getShipmentFeeType().equals(other.getShipmentFeeType()))
            && (this.getShipmentFeeAmount() == null ? other.getShipmentFeeAmount() == null : this.getShipmentFeeAmount().equals(other.getShipmentFeeAmount()))
            && (this.getOrderFeeType() == null ? other.getOrderFeeType() == null : this.getOrderFeeType().equals(other.getOrderFeeType()))
            && (this.getOrderFeeAmount() == null ? other.getOrderFeeAmount() == null : this.getOrderFeeAmount().equals(other.getOrderFeeAmount()))
            && (this.getFulfillmentId() == null ? other.getFulfillmentId() == null : this.getFulfillmentId().equals(other.getFulfillmentId()))
            && (this.getPostedDate() == null ? other.getPostedDate() == null : this.getPostedDate().equals(other.getPostedDate()))
            && (this.getOrderItemCode() == null ? other.getOrderItemCode() == null : this.getOrderItemCode().equals(other.getOrderItemCode()))
            && (this.getMerchantOrderItemId() == null ? other.getMerchantOrderItemId() == null : this.getMerchantOrderItemId().equals(other.getMerchantOrderItemId()))
            && (this.getMerchantAdjustmentItemId() == null ? other.getMerchantAdjustmentItemId() == null : this.getMerchantAdjustmentItemId().equals(other.getMerchantAdjustmentItemId()))
            && (this.getSku() == null ? other.getSku() == null : this.getSku().equals(other.getSku()))
            && (this.getQuantityPurchased() == null ? other.getQuantityPurchased() == null : this.getQuantityPurchased().equals(other.getQuantityPurchased()))
            && (this.getPriceType() == null ? other.getPriceType() == null : this.getPriceType().equals(other.getPriceType()))
            && (this.getPriceAmount() == null ? other.getPriceAmount() == null : this.getPriceAmount().equals(other.getPriceAmount()))
            && (this.getItemRelatedFeeType() == null ? other.getItemRelatedFeeType() == null : this.getItemRelatedFeeType().equals(other.getItemRelatedFeeType()))
            && (this.getItemRelatedFeeAmount() == null ? other.getItemRelatedFeeAmount() == null : this.getItemRelatedFeeAmount().equals(other.getItemRelatedFeeAmount()))
            && (this.getMiscFeeAmount() == null ? other.getMiscFeeAmount() == null : this.getMiscFeeAmount().equals(other.getMiscFeeAmount()))
            && (this.getOtherFeeAmount() == null ? other.getOtherFeeAmount() == null : this.getOtherFeeAmount().equals(other.getOtherFeeAmount()))
            && (this.getOtherFeeReasonDescription() == null ? other.getOtherFeeReasonDescription() == null : this.getOtherFeeReasonDescription().equals(other.getOtherFeeReasonDescription()))
            && (this.getDirectPaymentType() == null ? other.getDirectPaymentType() == null : this.getDirectPaymentType().equals(other.getDirectPaymentType()))
            && (this.getDirectPaymentAmount() == null ? other.getDirectPaymentAmount() == null : this.getDirectPaymentAmount().equals(other.getDirectPaymentAmount()))
            && (this.getOtherAmount() == null ? other.getOtherAmount() == null : this.getOtherAmount().equals(other.getOtherAmount()))
            && (this.getStatisticsTime() == null ? other.getStatisticsTime() == null : this.getStatisticsTime().equals(other.getStatisticsTime()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getReportId() == null) ? 0 : getReportId().hashCode());
        result = prime * result + ((getSettlementId() == null) ? 0 : getSettlementId().hashCode());
        result = prime * result + ((getSettlementStartDate() == null) ? 0 : getSettlementStartDate().hashCode());
        result = prime * result + ((getSettlementEndDate() == null) ? 0 : getSettlementEndDate().hashCode());
        result = prime * result + ((getDepositDate() == null) ? 0 : getDepositDate().hashCode());
        result = prime * result + ((getTotalAmount() == null) ? 0 : getTotalAmount().hashCode());
        result = prime * result + ((getCurrency() == null) ? 0 : getCurrency().hashCode());
        result = prime * result + ((getTransactionType() == null) ? 0 : getTransactionType().hashCode());
        result = prime * result + ((getOrderId() == null) ? 0 : getOrderId().hashCode());
        result = prime * result + ((getMerchantOrderId() == null) ? 0 : getMerchantOrderId().hashCode());
        result = prime * result + ((getAdjustmentId() == null) ? 0 : getAdjustmentId().hashCode());
        result = prime * result + ((getShipmentId() == null) ? 0 : getShipmentId().hashCode());
        result = prime * result + ((getMarketplaceName() == null) ? 0 : getMarketplaceName().hashCode());
        result = prime * result + ((getShipmentFeeType() == null) ? 0 : getShipmentFeeType().hashCode());
        result = prime * result + ((getShipmentFeeAmount() == null) ? 0 : getShipmentFeeAmount().hashCode());
        result = prime * result + ((getOrderFeeType() == null) ? 0 : getOrderFeeType().hashCode());
        result = prime * result + ((getOrderFeeAmount() == null) ? 0 : getOrderFeeAmount().hashCode());
        result = prime * result + ((getFulfillmentId() == null) ? 0 : getFulfillmentId().hashCode());
        result = prime * result + ((getPostedDate() == null) ? 0 : getPostedDate().hashCode());
        result = prime * result + ((getOrderItemCode() == null) ? 0 : getOrderItemCode().hashCode());
        result = prime * result + ((getMerchantOrderItemId() == null) ? 0 : getMerchantOrderItemId().hashCode());
        result = prime * result + ((getMerchantAdjustmentItemId() == null) ? 0 : getMerchantAdjustmentItemId().hashCode());
        result = prime * result + ((getSku() == null) ? 0 : getSku().hashCode());
        result = prime * result + ((getQuantityPurchased() == null) ? 0 : getQuantityPurchased().hashCode());
        result = prime * result + ((getPriceType() == null) ? 0 : getPriceType().hashCode());
        result = prime * result + ((getPriceAmount() == null) ? 0 : getPriceAmount().hashCode());
        result = prime * result + ((getItemRelatedFeeType() == null) ? 0 : getItemRelatedFeeType().hashCode());
        result = prime * result + ((getItemRelatedFeeAmount() == null) ? 0 : getItemRelatedFeeAmount().hashCode());
        result = prime * result + ((getMiscFeeAmount() == null) ? 0 : getMiscFeeAmount().hashCode());
        result = prime * result + ((getOtherFeeAmount() == null) ? 0 : getOtherFeeAmount().hashCode());
        result = prime * result + ((getOtherFeeReasonDescription() == null) ? 0 : getOtherFeeReasonDescription().hashCode());
        result = prime * result + ((getDirectPaymentType() == null) ? 0 : getDirectPaymentType().hashCode());
        result = prime * result + ((getDirectPaymentAmount() == null) ? 0 : getDirectPaymentAmount().hashCode());
        result = prime * result + ((getOtherAmount() == null) ? 0 : getOtherAmount().hashCode());
        result = prime * result + ((getStatisticsTime() == null) ? 0 : getStatisticsTime().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}