package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_sync_amazon_order")
public class JsSyncAmazonOrder extends IBaseModel implements Serializable {
    /**
     * 用户 id
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 平台店铺 id
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 亚马逊所定义的订单编码
     */
    @Column(name = "amazon_order_id")
    private String amazonOrderId;

    /**
     * 卖家所定义的订单编码
     */
    @Column(name = "seller_order_id")
    private String sellerOrderId;

    /**
     * 创建订单的日期
     */
    @Column(name = "purchase_date")
    private Date purchaseDate;

    /**
     * 订单的最后更新日期
     */
    @Column(name = "last_update_date")
    private Date lastUpdateDate;

    /**
     * 当前的订单状态
     */
    @Column(name = "order_status")
    private String orderStatus;

    /**
     * 已配送的商品数量
     */
    @Column(name = "number_of_items_shipped")
    private BigDecimal numberOfItemsShipped;

    /**
     * 货币类型
     */
    @Column(name = "currency_code")
    private String currencyCode;

    /**
     * 订单总金额
     */
    @Column(name = "order_total")
    private BigDecimal orderTotal;

    /**
     * 未配送的商品数量
     */
    @Column(name = "number_of_items_unshipped")
    private BigDecimal numberOfItemsUnshipped;

    /**
     * 订单生成所在商城的匿名编码
     */
    @Column(name = "marketplace_id")
    private String marketplaceId;

    /**
     * 买家的匿名电子邮件地址
     */
    @Column(name = "buyer_email")
    private String buyerEmail;

    /**
     * 买家姓名
     */
    @Column(name = "buyer_name")
    private String buyerName;

    @Column(name = "shipping_address_id")
    private String shippingAddressId;

    /**
     * 订单类型
     */
    @Column(name = "order_type")
    private String orderType;

    /**
     * 替换订单 id
     */
    @Column(name = "replaced_order_id")
    private String replacedOrderId;

    /**
     * 是否是替换订单
     */
    @Column(name = "is_replacement_order")
    private Boolean isReplacementOrder;

    /**
     * 已配送的商品数量
     */
    @Column(name = "promise_response_due_date")
    private Date promiseResponseDueDate;

    /**
     * 已配送的商品数量
     */
    @Column(name = "is_estimated_ship_date_set")
    private Boolean isEstimatedShipDateSet;

    /**
     * 同步时间
     */
    @Column(name = "sync_date")
    private Date syncDate;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsSyncAmazonOrder other = (JsSyncAmazonOrder) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getAmazonOrderId() == null ? other.getAmazonOrderId() == null : this.getAmazonOrderId().equals(other.getAmazonOrderId()))
            && (this.getSellerOrderId() == null ? other.getSellerOrderId() == null : this.getSellerOrderId().equals(other.getSellerOrderId()))
            && (this.getPurchaseDate() == null ? other.getPurchaseDate() == null : this.getPurchaseDate().equals(other.getPurchaseDate()))
            && (this.getLastUpdateDate() == null ? other.getLastUpdateDate() == null : this.getLastUpdateDate().equals(other.getLastUpdateDate()))
            && (this.getOrderStatus() == null ? other.getOrderStatus() == null : this.getOrderStatus().equals(other.getOrderStatus()))
            && (this.getNumberOfItemsShipped() == null ? other.getNumberOfItemsShipped() == null : this.getNumberOfItemsShipped().equals(other.getNumberOfItemsShipped()))
            && (this.getCurrencyCode() == null ? other.getCurrencyCode() == null : this.getCurrencyCode().equals(other.getCurrencyCode()))
            && (this.getOrderTotal() == null ? other.getOrderTotal() == null : this.getOrderTotal().equals(other.getOrderTotal()))
            && (this.getNumberOfItemsUnshipped() == null ? other.getNumberOfItemsUnshipped() == null : this.getNumberOfItemsUnshipped().equals(other.getNumberOfItemsUnshipped()))
            && (this.getMarketplaceId() == null ? other.getMarketplaceId() == null : this.getMarketplaceId().equals(other.getMarketplaceId()))
            && (this.getBuyerEmail() == null ? other.getBuyerEmail() == null : this.getBuyerEmail().equals(other.getBuyerEmail()))
            && (this.getBuyerName() == null ? other.getBuyerName() == null : this.getBuyerName().equals(other.getBuyerName()))
            && (this.getShippingAddressId() == null ? other.getShippingAddressId() == null : this.getShippingAddressId().equals(other.getShippingAddressId()))
            && (this.getOrderType() == null ? other.getOrderType() == null : this.getOrderType().equals(other.getOrderType()))
            && (this.getReplacedOrderId() == null ? other.getReplacedOrderId() == null : this.getReplacedOrderId().equals(other.getReplacedOrderId()))
            && (this.getIsReplacementOrder() == null ? other.getIsReplacementOrder() == null : this.getIsReplacementOrder().equals(other.getIsReplacementOrder()))
            && (this.getPromiseResponseDueDate() == null ? other.getPromiseResponseDueDate() == null : this.getPromiseResponseDueDate().equals(other.getPromiseResponseDueDate()))
            && (this.getIsEstimatedShipDateSet() == null ? other.getIsEstimatedShipDateSet() == null : this.getIsEstimatedShipDateSet().equals(other.getIsEstimatedShipDateSet()))
            && (this.getSyncDate() == null ? other.getSyncDate() == null : this.getSyncDate().equals(other.getSyncDate()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getAmazonOrderId() == null) ? 0 : getAmazonOrderId().hashCode());
        result = prime * result + ((getSellerOrderId() == null) ? 0 : getSellerOrderId().hashCode());
        result = prime * result + ((getPurchaseDate() == null) ? 0 : getPurchaseDate().hashCode());
        result = prime * result + ((getLastUpdateDate() == null) ? 0 : getLastUpdateDate().hashCode());
        result = prime * result + ((getOrderStatus() == null) ? 0 : getOrderStatus().hashCode());
        result = prime * result + ((getNumberOfItemsShipped() == null) ? 0 : getNumberOfItemsShipped().hashCode());
        result = prime * result + ((getCurrencyCode() == null) ? 0 : getCurrencyCode().hashCode());
        result = prime * result + ((getOrderTotal() == null) ? 0 : getOrderTotal().hashCode());
        result = prime * result + ((getNumberOfItemsUnshipped() == null) ? 0 : getNumberOfItemsUnshipped().hashCode());
        result = prime * result + ((getMarketplaceId() == null) ? 0 : getMarketplaceId().hashCode());
        result = prime * result + ((getBuyerEmail() == null) ? 0 : getBuyerEmail().hashCode());
        result = prime * result + ((getBuyerName() == null) ? 0 : getBuyerName().hashCode());
        result = prime * result + ((getShippingAddressId() == null) ? 0 : getShippingAddressId().hashCode());
        result = prime * result + ((getOrderType() == null) ? 0 : getOrderType().hashCode());
        result = prime * result + ((getReplacedOrderId() == null) ? 0 : getReplacedOrderId().hashCode());
        result = prime * result + ((getIsReplacementOrder() == null) ? 0 : getIsReplacementOrder().hashCode());
        result = prime * result + ((getPromiseResponseDueDate() == null) ? 0 : getPromiseResponseDueDate().hashCode());
        result = prime * result + ((getIsEstimatedShipDateSet() == null) ? 0 : getIsEstimatedShipDateSet().hashCode());
        result = prime * result + ((getSyncDate() == null) ? 0 : getSyncDate().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        return result;
    }
}