package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_supplier_bat")
public class JsPaySupplierBat extends IBaseModel implements Serializable {
    /**
     * 批次号
     */
    @Id
    @Column(name = "batch_id")
    private String batchId;

    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 总金额
     */
    @Column(name = "total_amt")
    private BigDecimal totalAmt;

    /**
     * 总笔数
     */
    @Column(name = "total_num")
    private Integer totalNum;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 付款批次状态 [F1 文件解析失败 F2 文件解析成功 D1 交易全部失败 D2 交易全部成功 D3 交易部分成功]
     */
    @Column(name = "batch_status")
    private String batchStatus;

    /**
     * 付款币种
     */
    @Column(name = "pay_cur")
    private String payCur;

    /**
     * 店铺ID
     */
    @Column(name = "store_id")
    private String storeId;

    /**
     * 电商平台 01 amazon ，02 ebay ，03 yahoo，04 fril  ，05 mercari
     */
    @Column(name = "store_plateform")
    private String storePlateform;

    /**
     * 错误原因
     */
    @Column(name = "err_info")
    private String errInfo;

    /**
     * 成功笔数
     */
    @Column(name = "succ_num")
    private Integer succNum;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySupplierBat other = (JsPaySupplierBat) that;
        return (this.getBatchId() == null ? other.getBatchId() == null : this.getBatchId().equals(other.getBatchId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getTotalAmt() == null ? other.getTotalAmt() == null : this.getTotalAmt().equals(other.getTotalAmt()))
            && (this.getTotalNum() == null ? other.getTotalNum() == null : this.getTotalNum().equals(other.getTotalNum()))
            && (this.getPhone() == null ? other.getPhone() == null : this.getPhone().equals(other.getPhone()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBatchStatus() == null ? other.getBatchStatus() == null : this.getBatchStatus().equals(other.getBatchStatus()))
            && (this.getPayCur() == null ? other.getPayCur() == null : this.getPayCur().equals(other.getPayCur()))
            && (this.getStoreId() == null ? other.getStoreId() == null : this.getStoreId().equals(other.getStoreId()))
            && (this.getStorePlateform() == null ? other.getStorePlateform() == null : this.getStorePlateform().equals(other.getStorePlateform()))
            && (this.getErrInfo() == null ? other.getErrInfo() == null : this.getErrInfo().equals(other.getErrInfo()))
            && (this.getSuccNum() == null ? other.getSuccNum() == null : this.getSuccNum().equals(other.getSuccNum()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getBatchId() == null) ? 0 : getBatchId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getTotalAmt() == null) ? 0 : getTotalAmt().hashCode());
        result = prime * result + ((getTotalNum() == null) ? 0 : getTotalNum().hashCode());
        result = prime * result + ((getPhone() == null) ? 0 : getPhone().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBatchStatus() == null) ? 0 : getBatchStatus().hashCode());
        result = prime * result + ((getPayCur() == null) ? 0 : getPayCur().hashCode());
        result = prime * result + ((getStoreId() == null) ? 0 : getStoreId().hashCode());
        result = prime * result + ((getStorePlateform() == null) ? 0 : getStorePlateform().hashCode());
        result = prime * result + ((getErrInfo() == null) ? 0 : getErrInfo().hashCode());
        result = prime * result + ((getSuccNum() == null) ? 0 : getSuccNum().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}