package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.js.common.enums.LockPriceTypeEnum;
import com.js.common.enums.TradeSubTypeEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sunrate_trade_lock_price")
public class JsPaySunrateTradeLockPrice extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @Column(name = "kyc_sunrate_bank_id")
    private String kycSunrateBankId;

    /**
     * 锁汇流水号
     */
    @Column(name = "lock_no")
    private String lockNo;

    /**
     * 询价流水号
     */
    @Column(name = "query_no")
    private String queryNo;

    /**
     * 锁汇交易编号-Key-寻汇交易唯一编号
     */
    @Column(name = "txn_no")
    private String txnNo;

    /**
     * 请求锁汇交易方式（TRADE_QUERY_PRICE-询价锁汇，TRADE_MARKET_ORDER-市价锁汇）
     */
    @Column(name = "request_type")
    private LockPriceTypeEnum requestType;

    /**
     * 店铺ID
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;

    /**
     * 组织结构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 买入币种
     */
    @Column(name = "buy_cur")
    private String buyCur;

    /**
     * 买入金额
     */
    @Column(name = "buy_amt")
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    @Column(name = "sell_cur")
    private String sellCur;

    /**
     * 卖出金额
     */
    @Column(name = "sell_amt")
    private BigDecimal sellAmt;

    /**
     * 手续费币种
     */
    @Column(name = "fee_cur")
    private String feeCur;

    /**
     * 询价汇率
     */
    @Column(name = "query_rate")
    private BigDecimal queryRate;

    /**
     * 交割日期
     */
    @Column(name = "value_date")
    private String valueDate;

    /**
     * 受益人编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;

    /**
     * 手续费金额
     */
    @Column(name = "fee_amt")
    private BigDecimal feeAmt;

    /**
     * 支付总金额
     */
    @Column(name = "pay_amt")
    private BigDecimal payAmt;

    /**
     * 交易模式
     */
    @Column(name = "txn_mode")
    private String txnMode;

    /**
     * 交易金额
     */
    @Column(name = "txn_amt")
    private BigDecimal txnAmt;

    /**
     * 成交汇率
     */
    @Column(name = "fin_rate")
    private BigDecimal finRate;

    /**
     * 交易状态02：交易确认  ， 03：入账已确认 ，  09：出账完成 ,99调用失败
     */
    @Column(name = "txn_status")
    private String txnStatus;

    /**
     * 备注
     */
    private String remark;

    /**
     * 交易方式（REPAYMENT-还款，WITHDRAW-提现）
     */
    @Column(name = "trade_type")
    private TradeSubTypeEnum tradeType;

    /**
     * 银行卡信息主键ID
     */
    @Column(name = "kyc_bank_id")
    private String kycBankId;

    /**
     * 银行卡信息主键ID
     */
    @Column(name = "bank_no")
    private String bankNo;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySunrateTradeLockPrice other = (JsPaySunrateTradeLockPrice) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycSunrateStoreId() == null ? other.getKycSunrateStoreId() == null : this.getKycSunrateStoreId().equals(other.getKycSunrateStoreId()))
            && (this.getKycSunrateBankId() == null ? other.getKycSunrateBankId() == null : this.getKycSunrateBankId().equals(other.getKycSunrateBankId()))
            && (this.getLockNo() == null ? other.getLockNo() == null : this.getLockNo().equals(other.getLockNo()))
            && (this.getQueryNo() == null ? other.getQueryNo() == null : this.getQueryNo().equals(other.getQueryNo()))
            && (this.getTxnNo() == null ? other.getTxnNo() == null : this.getTxnNo().equals(other.getTxnNo()))
            && (this.getRequestType() == null ? other.getRequestType() == null : this.getRequestType().equals(other.getRequestType()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBuyCur() == null ? other.getBuyCur() == null : this.getBuyCur().equals(other.getBuyCur()))
            && (this.getBuyAmt() == null ? other.getBuyAmt() == null : this.getBuyAmt().equals(other.getBuyAmt()))
            && (this.getSellCur() == null ? other.getSellCur() == null : this.getSellCur().equals(other.getSellCur()))
            && (this.getSellAmt() == null ? other.getSellAmt() == null : this.getSellAmt().equals(other.getSellAmt()))
            && (this.getFeeCur() == null ? other.getFeeCur() == null : this.getFeeCur().equals(other.getFeeCur()))
            && (this.getQueryRate() == null ? other.getQueryRate() == null : this.getQueryRate().equals(other.getQueryRate()))
            && (this.getValueDate() == null ? other.getValueDate() == null : this.getValueDate().equals(other.getValueDate()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getFeeAmt() == null ? other.getFeeAmt() == null : this.getFeeAmt().equals(other.getFeeAmt()))
            && (this.getPayAmt() == null ? other.getPayAmt() == null : this.getPayAmt().equals(other.getPayAmt()))
            && (this.getTxnMode() == null ? other.getTxnMode() == null : this.getTxnMode().equals(other.getTxnMode()))
            && (this.getTxnAmt() == null ? other.getTxnAmt() == null : this.getTxnAmt().equals(other.getTxnAmt()))
            && (this.getFinRate() == null ? other.getFinRate() == null : this.getFinRate().equals(other.getFinRate()))
            && (this.getTxnStatus() == null ? other.getTxnStatus() == null : this.getTxnStatus().equals(other.getTxnStatus()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getTradeType() == null ? other.getTradeType() == null : this.getTradeType().equals(other.getTradeType()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycSunrateStoreId() == null) ? 0 : getKycSunrateStoreId().hashCode());
        result = prime * result + ((getKycSunrateBankId() == null) ? 0 : getKycSunrateBankId().hashCode());
        result = prime * result + ((getLockNo() == null) ? 0 : getLockNo().hashCode());
        result = prime * result + ((getQueryNo() == null) ? 0 : getQueryNo().hashCode());
        result = prime * result + ((getTxnNo() == null) ? 0 : getTxnNo().hashCode());
        result = prime * result + ((getRequestType() == null) ? 0 : getRequestType().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBuyCur() == null) ? 0 : getBuyCur().hashCode());
        result = prime * result + ((getBuyAmt() == null) ? 0 : getBuyAmt().hashCode());
        result = prime * result + ((getSellCur() == null) ? 0 : getSellCur().hashCode());
        result = prime * result + ((getSellAmt() == null) ? 0 : getSellAmt().hashCode());
        result = prime * result + ((getFeeCur() == null) ? 0 : getFeeCur().hashCode());
        result = prime * result + ((getQueryRate() == null) ? 0 : getQueryRate().hashCode());
        result = prime * result + ((getValueDate() == null) ? 0 : getValueDate().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getFeeAmt() == null) ? 0 : getFeeAmt().hashCode());
        result = prime * result + ((getPayAmt() == null) ? 0 : getPayAmt().hashCode());
        result = prime * result + ((getTxnMode() == null) ? 0 : getTxnMode().hashCode());
        result = prime * result + ((getTxnAmt() == null) ? 0 : getTxnAmt().hashCode());
        result = prime * result + ((getFinRate() == null) ? 0 : getFinRate().hashCode());
        result = prime * result + ((getTxnStatus() == null) ? 0 : getTxnStatus().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getTradeType() == null) ? 0 : getTradeType().hashCode());
        return result;
    }
}