package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.js.common.enums.ProcessStatusEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sunrate_bank_trade_out")
public class JsPaySunrateBankTradeOut extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @Column(name = "kyc_sunrate_bank_id")
    private String kycSunrateBankId;

    /**
     * 锁汇流水号
     */
    @Column(name = "lock_no")
    private String lockNo;

    /**
     * 锁汇交易编号
     */
    @Column(name = "txn_no")
    private String txnNo;

    /**
     * 组织机构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 受益人编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;

    /**
     * 受益人名称
     */
    @Column(name = "beneficiary_name")
    private String beneficiaryName;

    /**
     * 受益人账户号码
     */
    @Column(name = "beneficiary_acct_no")
    private String beneficiaryAcctNo;

    /**
     * 出账币种
     */
    @Column(name = "pay_cur")
    private String payCur;

    /**
     * 出账金额
     */
    @Column(name = "pay_amt")
    private BigDecimal payAmt;

    /**
     * 备注
     */
    private String remark;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    @Column(name = "process_status")
    private ProcessStatusEnum processStatus;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySunrateBankTradeOut other = (JsPaySunrateBankTradeOut) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycSunrateStoreId() == null ? other.getKycSunrateStoreId() == null : this.getKycSunrateStoreId().equals(other.getKycSunrateStoreId()))
            && (this.getKycSunrateBankId() == null ? other.getKycSunrateBankId() == null : this.getKycSunrateBankId().equals(other.getKycSunrateBankId()))
            && (this.getLockNo() == null ? other.getLockNo() == null : this.getLockNo().equals(other.getLockNo()))
            && (this.getTxnNo() == null ? other.getTxnNo() == null : this.getTxnNo().equals(other.getTxnNo()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getBeneficiaryName() == null ? other.getBeneficiaryName() == null : this.getBeneficiaryName().equals(other.getBeneficiaryName()))
            && (this.getBeneficiaryAcctNo() == null ? other.getBeneficiaryAcctNo() == null : this.getBeneficiaryAcctNo().equals(other.getBeneficiaryAcctNo()))
            && (this.getPayCur() == null ? other.getPayCur() == null : this.getPayCur().equals(other.getPayCur()))
            && (this.getPayAmt() == null ? other.getPayAmt() == null : this.getPayAmt().equals(other.getPayAmt()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycSunrateStoreId() == null) ? 0 : getKycSunrateStoreId().hashCode());
        result = prime * result + ((getKycSunrateBankId() == null) ? 0 : getKycSunrateBankId().hashCode());
        result = prime * result + ((getLockNo() == null) ? 0 : getLockNo().hashCode());
        result = prime * result + ((getTxnNo() == null) ? 0 : getTxnNo().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getBeneficiaryName() == null) ? 0 : getBeneficiaryName().hashCode());
        result = prime * result + ((getBeneficiaryAcctNo() == null) ? 0 : getBeneficiaryAcctNo().hashCode());
        result = prime * result + ((getPayCur() == null) ? 0 : getPayCur().hashCode());
        result = prime * result + ((getPayAmt() == null) ? 0 : getPayAmt().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}