package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;

import com.js.common.enums.ProcessStatusEnum;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_sunrate_bank_trade_in")
public class JsPaySunrateBankTradeIn extends IBaseModel implements Serializable {
    /**
     * 注册信息表主键ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    @Column(name = "kyc_sunrate_store_id")
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    @Column(name = "kyc_sunrate_bank_id")
    private String kycSunrateBankId;

    /**
     * 入账通知编号
     */
    @Column(name = "transin_notice_id")
    private String transinNoticeId;

    /**
     * 组织结构代码
     */
    @Column(name = "org_code")
    private String orgCode;

    /**
     * 店铺ID(电商收款账户)
     */
    @Column(name = "sub_acct_no")
    private String subAcctNo;

    /**
     * 入账币种
     */
    @Column(name = "transin_cur")
    private String transinCur;

    /**
     * 入账金额
     */
    @Column(name = "transin_amt")
    private BigDecimal transinAmt;

    /**
     * 可用金额
     */
    @Column(name = "available_amt")
    private BigDecimal availableAmt;

    /**
     * 账户可用余额
     */
    @Column(name = "available_balance")
    private BigDecimal availableBalance;

    /**
     * 入账日期
     */
    @Column(name = "sys_txn_date")
    private Date sysTxnDate;

    /**
     * 银行卡号
     */
    @Column(name = "bank_card_no")
    private String bankCardNo;

    /**
     * 备注
     */
    private String remark;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    @Column(name = "process_status")
    private ProcessStatusEnum processStatus;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPaySunrateBankTradeIn other = (JsPaySunrateBankTradeIn) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getKycSunrateStoreId() == null ? other.getKycSunrateStoreId() == null : this.getKycSunrateStoreId().equals(other.getKycSunrateStoreId()))
            && (this.getKycSunrateBankId() == null ? other.getKycSunrateBankId() == null : this.getKycSunrateBankId().equals(other.getKycSunrateBankId()))
            && (this.getTransinNoticeId() == null ? other.getTransinNoticeId() == null : this.getTransinNoticeId().equals(other.getTransinNoticeId()))
            && (this.getOrgCode() == null ? other.getOrgCode() == null : this.getOrgCode().equals(other.getOrgCode()))
            && (this.getSubAcctNo() == null ? other.getSubAcctNo() == null : this.getSubAcctNo().equals(other.getSubAcctNo()))
            && (this.getTransinCur() == null ? other.getTransinCur() == null : this.getTransinCur().equals(other.getTransinCur()))
            && (this.getTransinAmt() == null ? other.getTransinAmt() == null : this.getTransinAmt().equals(other.getTransinAmt()))
            && (this.getAvailableAmt() == null ? other.getAvailableAmt() == null : this.getAvailableAmt().equals(other.getAvailableAmt()))
            && (this.getSysTxnDate() == null ? other.getSysTxnDate() == null : this.getSysTxnDate().equals(other.getSysTxnDate()))
            && (this.getBankCardNo() == null ? other.getBankCardNo() == null : this.getBankCardNo().equals(other.getBankCardNo()))
            && (this.getRemark() == null ? other.getRemark() == null : this.getRemark().equals(other.getRemark()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()))
            && (this.getProcessStatus() == null ? other.getProcessStatus() == null : this.getProcessStatus().equals(other.getProcessStatus()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getKycSunrateStoreId() == null) ? 0 : getKycSunrateStoreId().hashCode());
        result = prime * result + ((getKycSunrateBankId() == null) ? 0 : getKycSunrateBankId().hashCode());
        result = prime * result + ((getTransinNoticeId() == null) ? 0 : getTransinNoticeId().hashCode());
        result = prime * result + ((getOrgCode() == null) ? 0 : getOrgCode().hashCode());
        result = prime * result + ((getSubAcctNo() == null) ? 0 : getSubAcctNo().hashCode());
        result = prime * result + ((getTransinCur() == null) ? 0 : getTransinCur().hashCode());
        result = prime * result + ((getTransinAmt() == null) ? 0 : getTransinAmt().hashCode());
        result = prime * result + ((getAvailableAmt() == null) ? 0 : getAvailableAmt().hashCode());
        result = prime * result + ((getSysTxnDate() == null) ? 0 : getSysTxnDate().hashCode());
        result = prime * result + ((getBankCardNo() == null) ? 0 : getBankCardNo().hashCode());
        result = prime * result + ((getRemark() == null) ? 0 : getRemark().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        result = prime * result + ((getProcessStatus() == null) ? 0 : getProcessStatus().hashCode());
        return result;
    }
}