package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_pay_station_organ_info")
public class JsPayStationOrganInfo extends IBaseModel implements Serializable {
    /**
     * 税局机构id
     */
    @Id
    @Column(name = "tax_station_id")
    private String taxStationId;

    /**
     * 税局机构名称
     */
    @Column(name = "tax_station_name")
    private String taxStationName;

    /**
     * 受益人编号
     */
    @Column(name = "beneficiary_id")
    private String beneficiaryId;

    /**
     * 税务局类型[0:税局, 1:税务代理]
     */
    @Column(name = "tax_station_type")
    private String taxStationType;

    /**
     * 缴税收款账号
     */
    @Column(name = "bank_card_no")
    private String bankCardNo;

    /**
     * 税局国家代码
     */
    @Column(name = "tax_station_country")
    private String taxStationCountry;

    /**
     * 银行识别码BIC
     */
    @Column(name = "bank_bic")
    private String bankBic;

    /**
     * 银行名称
     */
    @Column(name = "bank_name")
    private String bankName;

    /**
     * 银行账户名称
     */
    @Column(name = "cus_name")
    private String cusName;

    /**
     * 国际银行账号 IBAN
     */
    private String iban;

    /**
     * Sort Code路由号码
     */
    @Column(name = "sort_code")
    private String sortCode;

    /**
     * 路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift 
     */
    @Column(name = "route_type")
    private String routeType;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsPayStationOrganInfo other = (JsPayStationOrganInfo) that;
        return (this.getTaxStationId() == null ? other.getTaxStationId() == null : this.getTaxStationId().equals(other.getTaxStationId()))
            && (this.getTaxStationName() == null ? other.getTaxStationName() == null : this.getTaxStationName().equals(other.getTaxStationName()))
            && (this.getBeneficiaryId() == null ? other.getBeneficiaryId() == null : this.getBeneficiaryId().equals(other.getBeneficiaryId()))
            && (this.getTaxStationType() == null ? other.getTaxStationType() == null : this.getTaxStationType().equals(other.getTaxStationType()))
            && (this.getBankCardNo() == null ? other.getBankCardNo() == null : this.getBankCardNo().equals(other.getBankCardNo()))
            && (this.getTaxStationCountry() == null ? other.getTaxStationCountry() == null : this.getTaxStationCountry().equals(other.getTaxStationCountry()))
            && (this.getBankBic() == null ? other.getBankBic() == null : this.getBankBic().equals(other.getBankBic()))
            && (this.getBankName() == null ? other.getBankName() == null : this.getBankName().equals(other.getBankName()))
            && (this.getCusName() == null ? other.getCusName() == null : this.getCusName().equals(other.getCusName()))
            && (this.getIban() == null ? other.getIban() == null : this.getIban().equals(other.getIban()))
            && (this.getSortCode() == null ? other.getSortCode() == null : this.getSortCode().equals(other.getSortCode()))
            && (this.getRouteType() == null ? other.getRouteType() == null : this.getRouteType().equals(other.getRouteType()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getTaxStationId() == null) ? 0 : getTaxStationId().hashCode());
        result = prime * result + ((getTaxStationName() == null) ? 0 : getTaxStationName().hashCode());
        result = prime * result + ((getBeneficiaryId() == null) ? 0 : getBeneficiaryId().hashCode());
        result = prime * result + ((getTaxStationType() == null) ? 0 : getTaxStationType().hashCode());
        result = prime * result + ((getBankCardNo() == null) ? 0 : getBankCardNo().hashCode());
        result = prime * result + ((getTaxStationCountry() == null) ? 0 : getTaxStationCountry().hashCode());
        result = prime * result + ((getBankBic() == null) ? 0 : getBankBic().hashCode());
        result = prime * result + ((getBankName() == null) ? 0 : getBankName().hashCode());
        result = prime * result + ((getCusName() == null) ? 0 : getCusName().hashCode());
        result = prime * result + ((getIban() == null) ? 0 : getIban().hashCode());
        result = prime * result + ((getSortCode() == null) ? 0 : getSortCode().hashCode());
        result = prime * result + ((getRouteType() == null) ? 0 : getRouteType().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}