package com.js.dal.dao.model;

import java.io.Serializable;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_loan_risk_info")
public class JsLoanRiskInfo extends IBaseModel implements Serializable {


    /**
     * 准入申请编号
     */
    @Column(name = "risk_no")
    private String riskNo;

    /**
     * KYC注册ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 借款人类型
     */
    @Column(name = "borrower_type")
    private String borrowerType;

    /**
     * 借款人姓名
     */
    @Column(name = "borrower_name")
    private String borrowerName;

    /**
     * 借款人手机号
     */
    @Column(name = "borrower_phone")
    private String borrowerPhone;

    /**
     * 借款人身份证号
     */
    @Column(name = "borrower_idcard")
    private String borrowerIdcard;

    /**
     * 借款人邮箱
     */
    @Column(name = "borrower_email")
    private String borrowerEmail;

    /**
     * 借款人婚姻状态
     */
    @Column(name = "marriage_status")
    private String marriageStatus;

    /**
     * 借款人同事联系方式
     */
    @Column(name = "borrower_colleague")
    private String borrowerColleague;

    /**
     * 借款人现家庭住址
     */
    @Column(name = "borrower_address")
    private String borrowerAddress;

    /**
     * 人行征信注册账号
     */
    @Column(name = "credit_reporting_no")
    private String creditReportingNo;

    /**
     * 人行征信登录密码
     */
    @Column(name = "credit_reporting_password")
    private String creditReportingPassword;

    /**
     * 人行征信身份验证码
     */
    @Column(name = "credit_reporting_authcode")
    private String creditReportingAuthcode;

    /**
     * 人行征信报告OSS地址
     */
    @Column(name = "credit_reporting_oss")
    private String creditReportingOss;

    /**
     * 担保人类型
     */
    @Column(name = "guarantee_type")
    private String guaranteeType;

    /**
     * 担保企业名称
     */
    @Column(name = "guarantee_corp")
    private String guaranteeCorp;

    /**
     * 担保企业统一信用代码
     */
    @Column(name = "guarantee_corp_orgcode")
    private String guaranteeCorpOrgcode;

    /**
     * 担保企业实际经营地址
     */
    @Column(name = "guarantee_corp_address")
    private String guaranteeCorpAddress;

    /**
     * 担保企业证明材料
     */
    @Column(name = "guarantee_corp_qualification")
    private String guaranteeCorpQualification;

    /**
     * 担保企业法人身份证正面
     */
    @Column(name = "guarantee_legalname_front")
    private String guaranteeLegalnameFront;

    /**
     * 担保企业法人身份证反面
     */
    @Column(name = "guarantee_legalname_back")
    private String guaranteeLegalnameBack;

    /**
     * 担保企业法人姓名
     */
    @Column(name = "guarantee_corp_legalname")
    private String guaranteeCorpLegalname;

    /**
     * 担保企业法人证件号码
     */
    @Column(name = "guarantee_corp_idcard")
    private String guaranteeCorpIdcard;

    /**
     * 担保企业法人手机号
     */
    @Column(name = "guarantee_corp_phone")
    private String guaranteeCorpPhone;

    /**
     * 担保企业法人邮箱
     */
    @Column(name = "guarantee_corp_email")
    private String guaranteeCorpEmail;

    /**
     * 担保企业法人身份证有效期
     */
    @Column(name = "guarantee_idcard_valid")
    private String guaranteeIdcardValid;

    /**
     * 担保企业法人家庭住址
     */
    @Column(name = "guarantee_legal_home_address")
    private String guaranteeLegalHomeAddress;

    /**
     * 担保企业法人办公地址
     */
    @Column(name = "guarantee_legal_office_address")
    private String guaranteeLegalOfficeAddress;

    /**
     * 企业对公账号
     */
    @Column(name = "corp_acct")
    private String corpAcct;

    /**
     * 对公开户行
     */
    @Column(name = "corp_acct_bank")
    private String corpAcctBank;

    /**
     * 对公开户行支行
     */
    @Column(name = "corp_acct_branch_bank")
    private String corpAcctBranchBank;

    /**
     * 是否打款验证通过
     */
    @Column(name = "is_corp_valid")
    private String isCorpValid;

    /**
     * 状态0审核中1审核通过2审核未通过
     */
    private String status;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsLoanRiskInfo other = (JsLoanRiskInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getRiskNo() == null ? other.getRiskNo() == null : this.getRiskNo().equals(other.getRiskNo()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getBorrowerType() == null ? other.getBorrowerType() == null : this.getBorrowerType().equals(other.getBorrowerType()))
            && (this.getBorrowerName() == null ? other.getBorrowerName() == null : this.getBorrowerName().equals(other.getBorrowerName()))
            && (this.getBorrowerPhone() == null ? other.getBorrowerPhone() == null : this.getBorrowerPhone().equals(other.getBorrowerPhone()))
            && (this.getBorrowerIdcard() == null ? other.getBorrowerIdcard() == null : this.getBorrowerIdcard().equals(other.getBorrowerIdcard()))
            && (this.getBorrowerEmail() == null ? other.getBorrowerEmail() == null : this.getBorrowerEmail().equals(other.getBorrowerEmail()))
            && (this.getMarriageStatus() == null ? other.getMarriageStatus() == null : this.getMarriageStatus().equals(other.getMarriageStatus()))
            && (this.getBorrowerColleague() == null ? other.getBorrowerColleague() == null : this.getBorrowerColleague().equals(other.getBorrowerColleague()))
            && (this.getBorrowerAddress() == null ? other.getBorrowerAddress() == null : this.getBorrowerAddress().equals(other.getBorrowerAddress()))
            && (this.getCreditReportingNo() == null ? other.getCreditReportingNo() == null : this.getCreditReportingNo().equals(other.getCreditReportingNo()))
            && (this.getCreditReportingPassword() == null ? other.getCreditReportingPassword() == null : this.getCreditReportingPassword().equals(other.getCreditReportingPassword()))
            && (this.getCreditReportingAuthcode() == null ? other.getCreditReportingAuthcode() == null : this.getCreditReportingAuthcode().equals(other.getCreditReportingAuthcode()))
            && (this.getCreditReportingOss() == null ? other.getCreditReportingOss() == null : this.getCreditReportingOss().equals(other.getCreditReportingOss()))
            && (this.getGuaranteeType() == null ? other.getGuaranteeType() == null : this.getGuaranteeType().equals(other.getGuaranteeType()))
            && (this.getGuaranteeCorp() == null ? other.getGuaranteeCorp() == null : this.getGuaranteeCorp().equals(other.getGuaranteeCorp()))
            && (this.getGuaranteeCorpOrgcode() == null ? other.getGuaranteeCorpOrgcode() == null : this.getGuaranteeCorpOrgcode().equals(other.getGuaranteeCorpOrgcode()))
            && (this.getGuaranteeCorpAddress() == null ? other.getGuaranteeCorpAddress() == null : this.getGuaranteeCorpAddress().equals(other.getGuaranteeCorpAddress()))
            && (this.getGuaranteeCorpQualification() == null ? other.getGuaranteeCorpQualification() == null : this.getGuaranteeCorpQualification().equals(other.getGuaranteeCorpQualification()))
            && (this.getGuaranteeLegalnameFront() == null ? other.getGuaranteeLegalnameFront() == null : this.getGuaranteeLegalnameFront().equals(other.getGuaranteeLegalnameFront()))
            && (this.getGuaranteeLegalnameBack() == null ? other.getGuaranteeLegalnameBack() == null : this.getGuaranteeLegalnameBack().equals(other.getGuaranteeLegalnameBack()))
            && (this.getGuaranteeCorpLegalname() == null ? other.getGuaranteeCorpLegalname() == null : this.getGuaranteeCorpLegalname().equals(other.getGuaranteeCorpLegalname()))
            && (this.getGuaranteeCorpIdcard() == null ? other.getGuaranteeCorpIdcard() == null : this.getGuaranteeCorpIdcard().equals(other.getGuaranteeCorpIdcard()))
            && (this.getGuaranteeCorpPhone() == null ? other.getGuaranteeCorpPhone() == null : this.getGuaranteeCorpPhone().equals(other.getGuaranteeCorpPhone()))
            && (this.getGuaranteeCorpEmail() == null ? other.getGuaranteeCorpEmail() == null : this.getGuaranteeCorpEmail().equals(other.getGuaranteeCorpEmail()))
            && (this.getGuaranteeIdcardValid() == null ? other.getGuaranteeIdcardValid() == null : this.getGuaranteeIdcardValid().equals(other.getGuaranteeIdcardValid()))
            && (this.getGuaranteeLegalHomeAddress() == null ? other.getGuaranteeLegalHomeAddress() == null : this.getGuaranteeLegalHomeAddress().equals(other.getGuaranteeLegalHomeAddress()))
            && (this.getGuaranteeLegalOfficeAddress() == null ? other.getGuaranteeLegalOfficeAddress() == null : this.getGuaranteeLegalOfficeAddress().equals(other.getGuaranteeLegalOfficeAddress()))
            && (this.getCorpAcct() == null ? other.getCorpAcct() == null : this.getCorpAcct().equals(other.getCorpAcct()))
            && (this.getCorpAcctBank() == null ? other.getCorpAcctBank() == null : this.getCorpAcctBank().equals(other.getCorpAcctBank()))
            && (this.getCorpAcctBranchBank() == null ? other.getCorpAcctBranchBank() == null : this.getCorpAcctBranchBank().equals(other.getCorpAcctBranchBank()))
            && (this.getIsCorpValid() == null ? other.getIsCorpValid() == null : this.getIsCorpValid().equals(other.getIsCorpValid()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getStatus() == null ? other.getStatus() == null : this.getStatus().equals(other.getStatus()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getRiskNo() == null) ? 0 : getRiskNo().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getBorrowerType() == null) ? 0 : getBorrowerType().hashCode());
        result = prime * result + ((getBorrowerName() == null) ? 0 : getBorrowerName().hashCode());
        result = prime * result + ((getBorrowerPhone() == null) ? 0 : getBorrowerPhone().hashCode());
        result = prime * result + ((getBorrowerIdcard() == null) ? 0 : getBorrowerIdcard().hashCode());
        result = prime * result + ((getBorrowerEmail() == null) ? 0 : getBorrowerEmail().hashCode());
        result = prime * result + ((getMarriageStatus() == null) ? 0 : getMarriageStatus().hashCode());
        result = prime * result + ((getBorrowerColleague() == null) ? 0 : getBorrowerColleague().hashCode());
        result = prime * result + ((getBorrowerAddress() == null) ? 0 : getBorrowerAddress().hashCode());
        result = prime * result + ((getCreditReportingNo() == null) ? 0 : getCreditReportingNo().hashCode());
        result = prime * result + ((getCreditReportingPassword() == null) ? 0 : getCreditReportingPassword().hashCode());
        result = prime * result + ((getCreditReportingAuthcode() == null) ? 0 : getCreditReportingAuthcode().hashCode());
        result = prime * result + ((getCreditReportingOss() == null) ? 0 : getCreditReportingOss().hashCode());
        result = prime * result + ((getGuaranteeType() == null) ? 0 : getGuaranteeType().hashCode());
        result = prime * result + ((getGuaranteeCorp() == null) ? 0 : getGuaranteeCorp().hashCode());
        result = prime * result + ((getGuaranteeCorpOrgcode() == null) ? 0 : getGuaranteeCorpOrgcode().hashCode());
        result = prime * result + ((getGuaranteeCorpAddress() == null) ? 0 : getGuaranteeCorpAddress().hashCode());
        result = prime * result + ((getGuaranteeCorpQualification() == null) ? 0 : getGuaranteeCorpQualification().hashCode());
        result = prime * result + ((getGuaranteeLegalnameFront() == null) ? 0 : getGuaranteeLegalnameFront().hashCode());
        result = prime * result + ((getGuaranteeLegalnameBack() == null) ? 0 : getGuaranteeLegalnameBack().hashCode());
        result = prime * result + ((getGuaranteeCorpLegalname() == null) ? 0 : getGuaranteeCorpLegalname().hashCode());
        result = prime * result + ((getGuaranteeCorpIdcard() == null) ? 0 : getGuaranteeCorpIdcard().hashCode());
        result = prime * result + ((getGuaranteeCorpPhone() == null) ? 0 : getGuaranteeCorpPhone().hashCode());
        result = prime * result + ((getGuaranteeCorpEmail() == null) ? 0 : getGuaranteeCorpEmail().hashCode());
        result = prime * result + ((getGuaranteeIdcardValid() == null) ? 0 : getGuaranteeIdcardValid().hashCode());
        result = prime * result + ((getGuaranteeLegalHomeAddress() == null) ? 0 : getGuaranteeLegalHomeAddress().hashCode());
        result = prime * result + ((getGuaranteeLegalOfficeAddress() == null) ? 0 : getGuaranteeLegalOfficeAddress().hashCode());
        result = prime * result + ((getCorpAcct() == null) ? 0 : getCorpAcct().hashCode());
        result = prime * result + ((getCorpAcctBank() == null) ? 0 : getCorpAcctBank().hashCode());
        result = prime * result + ((getCorpAcctBranchBank() == null) ? 0 : getCorpAcctBranchBank().hashCode());
        result = prime * result + ((getIsCorpValid() == null) ? 0 : getIsCorpValid().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getStatus() == null) ? 0 : getStatus().hashCode());
        return result;
    }
}