package com.js.dal.dao.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@Table(name = "js_loan_apply_info")
public class JsLoanApplyInfo extends IBaseModel implements Serializable {
    /**
     * 贷款申请编号
     */
    @Column(name = "loan_no")
    private String loanNo;

    /**
     * KYC注册ID
     */
    @Column(name = "kyc_natural_id")
    private String kycNaturalId;

    /**
     * 申请人名称
     */
    private String name;

    /**
     * 申请人手机号
     */
    private String phone;

    /**
     * 意向贷款金额
     */
    @Column(name = "apply_amt")
    private BigDecimal applyAmt;

    /**
     * 实际放款金额
     */
    @Column(name = "real_amt")
    private BigDecimal realAmt;

    /**
     * 申请贷款时间
     */
    @Column(name = "apply_date")
    private Date applyDate;

    /**
     * 放款时间
     */
    @Column(name = "pass_date")
    private Date passDate;

    /**
     * 贷款状态
     */
    @Column(name = "loan_status")
    private String loanStatus;

    /**
     * 借款天数
     */
    @Column(name = "loan_days")
    private Integer loanDays;

    /**
     * 综合费率
     */
    @Column(name = "total_rate")
    private BigDecimal totalRate;

    /**
     * 未还本金
     */
    @Column(name = "unpay_principal")
    private BigDecimal unpayPrincipal;

    /**
     * 未还利息
     */
    @Column(name = "unpay_interest")
    private BigDecimal unpayInterest;

    /**
     * 未还服务费
     */
    @Column(name = "unpay_fee")
    private BigDecimal unpayFee;

    /**
     * 未还罚息
     */
    @Column(name = "unpay_penalty")
    private BigDecimal unpayPenalty;

    /**
     * 未还提前还款手续费
     */
    @Column(name = "unpay_prepayment_fee")
    private BigDecimal unpayPrepaymentFee;

    /**
     * 已还本金
     */
    @Column(name = "paid_principal")
    private BigDecimal paidPrincipal;

    /**
     * 已还利息
     */
    @Column(name = "paid_interest")
    private BigDecimal paidInterest;

    /**
     * 已还服务费
     */
    @Column(name = "paid_fee")
    private BigDecimal paidFee;

    /**
     * 已还罚息
     */
    @Column(name = "paid_penalty")
    private BigDecimal paidPenalty;

    /**
     * 已还提前还款手续费
     */
    @Column(name = "paid_prepayment_fee")
    private BigDecimal paidPrepaymentFee;

    /**
     * 最早还款时间
     */
    @Column(name = "first_repay_time")
    private Date firstRepayTime;

    /**
     * 最晚还款时间
     */
    @Column(name = "last_repay_time")
    private Date lastRepayTime;

    /**
     * 还款方式
     */
    @Column(name = "repay_type")
    private String repayType;

    /**
     * 收款账户id
     */
    @Column(name = "user_acct_id")
    private String userAcctId;

    /**
     * 收款账户名称
     */
    @Column(name = "acct_name")
    private String acctName;

    /**
     * 收款账户号
     */
    @Column(name = "acct_no")
    private String acctNo;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        JsLoanApplyInfo other = (JsLoanApplyInfo) that;
        return (this.getId() == null ? other.getId() == null : this.getId().equals(other.getId()))
            && (this.getLoanNo() == null ? other.getLoanNo() == null : this.getLoanNo().equals(other.getLoanNo()))
            && (this.getKycNaturalId() == null ? other.getKycNaturalId() == null : this.getKycNaturalId().equals(other.getKycNaturalId()))
            && (this.getName() == null ? other.getName() == null : this.getName().equals(other.getName()))
            && (this.getPhone() == null ? other.getPhone() == null : this.getPhone().equals(other.getPhone()))
            && (this.getApplyAmt() == null ? other.getApplyAmt() == null : this.getApplyAmt().equals(other.getApplyAmt()))
            && (this.getRealAmt() == null ? other.getRealAmt() == null : this.getRealAmt().equals(other.getRealAmt()))
            && (this.getApplyDate() == null ? other.getApplyDate() == null : this.getApplyDate().equals(other.getApplyDate()))
            && (this.getPassDate() == null ? other.getPassDate() == null : this.getPassDate().equals(other.getPassDate()))
            && (this.getLoanStatus() == null ? other.getLoanStatus() == null : this.getLoanStatus().equals(other.getLoanStatus()))
            && (this.getLoanDays() == null ? other.getLoanDays() == null : this.getLoanDays().equals(other.getLoanDays()))
            && (this.getTotalRate() == null ? other.getTotalRate() == null : this.getTotalRate().equals(other.getTotalRate()))
            && (this.getUnpayPrincipal() == null ? other.getUnpayPrincipal() == null : this.getUnpayPrincipal().equals(other.getUnpayPrincipal()))
            && (this.getUnpayInterest() == null ? other.getUnpayInterest() == null : this.getUnpayInterest().equals(other.getUnpayInterest()))
            && (this.getUnpayFee() == null ? other.getUnpayFee() == null : this.getUnpayFee().equals(other.getUnpayFee()))
            && (this.getUnpayPenalty() == null ? other.getUnpayPenalty() == null : this.getUnpayPenalty().equals(other.getUnpayPenalty()))
            && (this.getUnpayPrepaymentFee() == null ? other.getUnpayPrepaymentFee() == null : this.getUnpayPrepaymentFee().equals(other.getUnpayPrepaymentFee()))
            && (this.getPaidPrincipal() == null ? other.getPaidPrincipal() == null : this.getPaidPrincipal().equals(other.getPaidPrincipal()))
            && (this.getPaidInterest() == null ? other.getPaidInterest() == null : this.getPaidInterest().equals(other.getPaidInterest()))
            && (this.getPaidFee() == null ? other.getPaidFee() == null : this.getPaidFee().equals(other.getPaidFee()))
            && (this.getPaidPenalty() == null ? other.getPaidPenalty() == null : this.getPaidPenalty().equals(other.getPaidPenalty()))
            && (this.getPaidPrepaymentFee() == null ? other.getPaidPrepaymentFee() == null : this.getPaidPrepaymentFee().equals(other.getPaidPrepaymentFee()))
            && (this.getFirstRepayTime() == null ? other.getFirstRepayTime() == null : this.getFirstRepayTime().equals(other.getFirstRepayTime()))
            && (this.getLastRepayTime() == null ? other.getLastRepayTime() == null : this.getLastRepayTime().equals(other.getLastRepayTime()))
            && (this.getRepayType() == null ? other.getRepayType() == null : this.getRepayType().equals(other.getRepayType()))
            && (this.getUserAcctId() == null ? other.getUserAcctId() == null : this.getUserAcctId().equals(other.getUserAcctId()))
            && (this.getAcctName() == null ? other.getAcctName() == null : this.getAcctName().equals(other.getAcctName()))
            && (this.getAcctNo() == null ? other.getAcctNo() == null : this.getAcctNo().equals(other.getAcctNo()))
            && (this.getCreateId() == null ? other.getCreateId() == null : this.getCreateId().equals(other.getCreateId()))
            && (this.getCreateName() == null ? other.getCreateName() == null : this.getCreateName().equals(other.getCreateName()))
            && (this.getCreateDts() == null ? other.getCreateDts() == null : this.getCreateDts().equals(other.getCreateDts()))
            && (this.getUpdateId() == null ? other.getUpdateId() == null : this.getUpdateId().equals(other.getUpdateId()))
            && (this.getUpdateName() == null ? other.getUpdateName() == null : this.getUpdateName().equals(other.getUpdateName()))
            && (this.getUpdateDts() == null ? other.getUpdateDts() == null : this.getUpdateDts().equals(other.getUpdateDts()))
            && (this.getJsRemark() == null ? other.getJsRemark() == null : this.getJsRemark().equals(other.getJsRemark()))
            && (this.getDelFlag() == null ? other.getDelFlag() == null : this.getDelFlag().equals(other.getDelFlag()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getId() == null) ? 0 : getId().hashCode());
        result = prime * result + ((getLoanNo() == null) ? 0 : getLoanNo().hashCode());
        result = prime * result + ((getKycNaturalId() == null) ? 0 : getKycNaturalId().hashCode());
        result = prime * result + ((getName() == null) ? 0 : getName().hashCode());
        result = prime * result + ((getPhone() == null) ? 0 : getPhone().hashCode());
        result = prime * result + ((getApplyAmt() == null) ? 0 : getApplyAmt().hashCode());
        result = prime * result + ((getRealAmt() == null) ? 0 : getRealAmt().hashCode());
        result = prime * result + ((getApplyDate() == null) ? 0 : getApplyDate().hashCode());
        result = prime * result + ((getPassDate() == null) ? 0 : getPassDate().hashCode());
        result = prime * result + ((getLoanStatus() == null) ? 0 : getLoanStatus().hashCode());
        result = prime * result + ((getLoanDays() == null) ? 0 : getLoanDays().hashCode());
        result = prime * result + ((getTotalRate() == null) ? 0 : getTotalRate().hashCode());
        result = prime * result + ((getUnpayPrincipal() == null) ? 0 : getUnpayPrincipal().hashCode());
        result = prime * result + ((getUnpayInterest() == null) ? 0 : getUnpayInterest().hashCode());
        result = prime * result + ((getUnpayFee() == null) ? 0 : getUnpayFee().hashCode());
        result = prime * result + ((getUnpayPenalty() == null) ? 0 : getUnpayPenalty().hashCode());
        result = prime * result + ((getUnpayPrepaymentFee() == null) ? 0 : getUnpayPrepaymentFee().hashCode());
        result = prime * result + ((getPaidPrincipal() == null) ? 0 : getPaidPrincipal().hashCode());
        result = prime * result + ((getPaidInterest() == null) ? 0 : getPaidInterest().hashCode());
        result = prime * result + ((getPaidFee() == null) ? 0 : getPaidFee().hashCode());
        result = prime * result + ((getPaidPenalty() == null) ? 0 : getPaidPenalty().hashCode());
        result = prime * result + ((getPaidPrepaymentFee() == null) ? 0 : getPaidPrepaymentFee().hashCode());
        result = prime * result + ((getFirstRepayTime() == null) ? 0 : getFirstRepayTime().hashCode());
        result = prime * result + ((getLastRepayTime() == null) ? 0 : getLastRepayTime().hashCode());
        result = prime * result + ((getRepayType() == null) ? 0 : getRepayType().hashCode());
        result = prime * result + ((getUserAcctId() == null) ? 0 : getUserAcctId().hashCode());
        result = prime * result + ((getAcctName() == null) ? 0 : getAcctName().hashCode());
        result = prime * result + ((getAcctNo() == null) ? 0 : getAcctNo().hashCode());
        result = prime * result + ((getCreateId() == null) ? 0 : getCreateId().hashCode());
        result = prime * result + ((getCreateName() == null) ? 0 : getCreateName().hashCode());
        result = prime * result + ((getCreateDts() == null) ? 0 : getCreateDts().hashCode());
        result = prime * result + ((getUpdateId() == null) ? 0 : getUpdateId().hashCode());
        result = prime * result + ((getUpdateName() == null) ? 0 : getUpdateName().hashCode());
        result = prime * result + ((getUpdateDts() == null) ? 0 : getUpdateDts().hashCode());
        result = prime * result + ((getJsRemark() == null) ? 0 : getJsRemark().hashCode());
        result = prime * result + ((getDelFlag() == null) ? 0 : getDelFlag().hashCode());
        return result;
    }
}