package com.js.common.util;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.IdUtil;
import com.aliyun.oss.OSSClient;
import com.js.common.JsException.LogicException;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.FileVo;
import com.js.common.model.vo.common.ResponseMessage;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @Author yjzhao
 * @Description 文件上传
 * @Date 2019/5/17 16:08
 * @Param
 * @return
 **/
@Setter
@Getter
@Slf4j
public class FileMngForOSSUtil {

    OSSUtil oSSUtil;

    /** oss bucket */
    private  String bucket;

    /** 存储基本路径 */
    private  String baseFileKey;

    /** 本地暂存地址 */
    private  String tempFilePath;

    public FileMngForOSSUtil(String bucket, String baseFileKey, OSSClient ossClient) {
        this.bucket = bucket;
        this.baseFileKey = baseFileKey;
        this.oSSUtil = new OSSUtil();
        oSSUtil.setOssClient(ossClient);
    }

   /**
    * @Author yjzhao
    * @Description 上传至阿里云OSS
    * @Date 2018/12/27 15:18
    * @Param [file, fileType]
    * @return com.js.common.model.vo.common.ResponseMessage
    **/
    public FileVo fileUpload(MultipartFile file, FileType fileType, FileResourceType fileResourceType){
        FileVo fileVo = new FileVo();
        //获取文件全名
        String fileName = file.getOriginalFilename();
        //获取文件扩展名
        String fileExt = FileUtil.extName(fileName);
        //原文件名
        String fileNamePas = FileUtil.mainName(fileName);
        //生成uuid
        String uuid = IdUtil.simpleUUID();
        //文件大小
        Long size = file.getSize();

        //存储文件文件名
        String newFileName = uuid + "." + fileExt;

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateNowStr = sdf.format(new Date());

        String saveFileKey = baseFileKey + "/" + fileType + "/" + dateNowStr + "/" + newFileName;
        try {
            //上传至OSS
            //上传前图片压缩
            if (FileType.IMAGE == fileType) {
                byte[] bytes = file.getBytes();
                ByteArrayInputStream fileByteArrayInputStream = ImageCompressUtil.compressPicForScale(bytes, 1024);
                oSSUtil.uploadByInputStream(bucket, saveFileKey, fileByteArrayInputStream);
            } else {
                oSSUtil.uploadByInputStream(bucket, saveFileKey, file.getInputStream());
            }
            fileVo.setFileSavePath(saveFileKey);
            fileVo.setFileSaveName(newFileName);
            fileVo.setFileShowPath(fileName);
            fileVo.setFileShowName(fileNamePas);
            //fileVo.setFileThumbnailPath();
            fileVo.setFileExt(fileExt);
            fileVo.setFileSize(size.intValue());
            fileVo.setFileResourceType(fileResourceType);
            fileVo.setFileType(fileType);
        } catch (IOException e) {
            log.error(fileName + "上传文件异常", e);
            throw LogicException.le(ResultEnum.FILE_UPLOAD_ERROR);
        }
        return fileVo;
    }

    /**
     * @Author liuh
     * @Description 上传至阿里云OSS
     * @Date 2019/7/15
     **/
    public FileVo fileUpload(InputStream inputStream, FileType fileType, FileResourceType fileResourceType,String fileName,String fileExt){
        FileVo fileVo = new FileVo();
        //原文件名
        String fileNamePas = FileUtil.mainName(fileName);
        //生成uuid
        String uuid = IdUtil.simpleUUID();

        //存储文件文件名
        String newFileName = uuid + "." + fileExt;

        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateNowStr = sdf.format(new Date());

        String saveFileKey = baseFileKey + "/" + fileType + "/" + dateNowStr + "/" + newFileName;
        try {
            //上传至OSS
            oSSUtil.uploadByInputStream(bucket, saveFileKey, inputStream);
            fileVo.setFileSavePath(saveFileKey);
            fileVo.setFileSaveName(newFileName);
            fileVo.setFileShowPath(fileName);
            fileVo.setFileShowName(fileNamePas);
            //fileVo.setFileThumbnailPath();
            fileVo.setFileExt(fileExt);
            fileVo.setFileSize(1);
            fileVo.setFileResourceType(fileResourceType);
            fileVo.setFileType(fileType);
        } catch (Exception e) {
            log.error(fileName + "上传文件异常", e);
            throw LogicException.le(ResultEnum.FILE_UPLOAD_ERROR);
        }
        return fileVo;
    }


    /**
     * @Author yjzhao
     * @Description 删除阿里云OSS中文件
     * @Date 2018/12/27 15:19
     * @Param [fileKey]
     * @return com.ciip.cloud.core.common.vo.ResponseMessage
     **/
    public  ResponseMessage deleteFile(String fileKey) {
        oSSUtil.deleteObject(bucket, fileKey);
        return ResultUtil.success(ResultEnum.FILE_DELETE_SUCCESS.getCode(),ResultEnum.FILE_DELETE_SUCCESS.getMsg());
    }

    /**
     * @Author yjzhao
     * @Description 获取文件流
     * @Date 2019/5/17 16:24
     * @Param [fileKey]
     * @return java.io.InputStream
     **/
    public InputStream findFile(String fileKey){
        return oSSUtil.getOSSInputStream(bucket, fileKey);
    }

    /**
     * @Author yjzhao
     * @Description 复制文件
     * @Date 2019/5/17 16:31
     * @Param [sourceObjectName, destinationObjectName]
     * @return boolean
     **/
    public boolean copyObject(String sourceObjectName, String destinationObjectName){
        return oSSUtil.copyObject(bucket, sourceObjectName, destinationObjectName);
    }

    /**
     * @Author liuh
     * @Description 获取图片类型base64工具
     * @Date 2019/8/1
     **/
    public static String findFileBase64(InputStream inputStream){
        ByteArrayOutputStream outputStream = null;
        byte[] buffer = null;
        try {
            outputStream = new ByteArrayOutputStream();
            // 将内容读取内存中
            buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            buffer = outputStream.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (inputStream != null) {
                try {
                    // 关闭inputStream流
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    // 关闭outputStream流
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        // 对字节数组Base64编码
        return new BASE64Encoder().encode(buffer);
    }
}
