package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySupplierGBPVO<T> extends JsPaySupplierVO {
    /**
     * 收款方银行所在地（地区国家代码，如：HK、CN、JP）
     */
    private String rcvBankCountry;
    /**
     * 收款方银行卡号
     */
    private String rcvBankCard;
    /**
     * 路由类型
     */
    private String routeType;
    /**
     * Sort Code银行分类号码
     */
    private String sortCode;

    /**
     * SWIFT/BIC编码
     */
    private String swiftBic;
    /**
     * 银行地址
     */
    private String bankAddr;

    @Override
    public String toString(){
        return  super.toString()+ "rcvBankName|iban|swiftBic|bankAddr" + endString() ;
    }
}
