package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySunrateTradeQueryPriceVo implements Serializable {
    private static final long serialVersionUID = 7257188299978495173L;
    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    private String kycSunrateBankId;

    /**
     * 询价流水号
     */
    private String queryNo;

    /**
     * 组织机构代码
     */
    private String orgCode;

    /**
     * 买入币种
     */
    private String buyCur;

    /**
     * 买入金额
     */
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    private String sellCur;

    /**
     * 卖出金额
     */
    private BigDecimal sellAmt;

    /**
     * 交易模式
     */
    private String txnMode;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;

    /**
     * 手续费金额
     */
    private BigDecimal feeAmt;

    /**
     * 手续费币种
     */
    private String feeCur;

    /**
     * 支付总金额
     */
    private BigDecimal payAmt;

    /**
     * 询价汇率
     */
    private BigDecimal queryRate;

    private Date queryDate = new Date();
}