package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SunrateTradePriceReq implements Serializable{
    private static final long serialVersionUID = -7542136521231312321L;
    /**
     *合作方询价流水号
     */
    private String queryNo;

    /**
     * 组织机构代码
     */
    @NotBlank(message = "组织机构代码不能为空")
    private String orgCode;

    /**
     * 买入币种  如：USD
     */
    @NotBlank(message = "买入币种不能为空")
    private String buyCur;

    /**
     * 卖出币种  如：CNY
     */
    @NotBlank(message = "卖出币种不能为空")
    private String sellCur;

    /**
     * 交易模式(0：买入模式,1：卖出模式)
     */
    @NotBlank(message = "交易模式不能为空")
    private String txnMode;

    /**
     * 交易金额
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal txnAmt;

    /**
     * 客户端浏览器IP
     */
    @NotBlank(message = "客户端IP不能为空")
    private String browserIP;
}