package com.js.common.model.req;

import com.js.common.enums.SiteEnum;
import com.js.common.enums.StorePlateformEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class KycStoreCheckTokenReq implements Serializable{

    private static final long serialVersionUID = -4188275781071008237L;

    /**
     * 店铺所在站点
     */
    @NotNull(message = "店铺所在站点CODE编码不能为空")
    private SiteEnum storeTheSite;

    /**
     * 卖家编号
     */
    @NotNull(message = "卖家 id 不能为空")
    private String sellId;

    /**
     * MWS授权令牌
     */
    @NotNull(message = "授权 token 不能为空")
    private String mwsAuthToken;

}