package com.js.common.model.req;

import com.js.common.enums.SiteEnum;
import com.js.common.enums.StorePlateformEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class KycShowStoreReq implements Serializable{
    private static final long serialVersionUID = -5503270679216717356L;
    /**
     * 店铺所在平台CODE
     */
    private StorePlateformEnum storePlateform;

    /**
     * 账户持有人或店铺名称
     */
    private String conditionName;

    private String kycNaturalId;

    /**
     * 起始页码
     */
    private Integer startPage = 0;
    /**
     * 每页限制条数
     */
    private Integer pageSize = 5;

    private boolean delFlag;

    /**
     * 店铺所在站点
     */
    private SiteEnum storeTheSite;

    private String browserIP;

    private String sellCur;


}