package com.js.common.model.req;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPayTradeReq implements Serializable {
    private static final long serialVersionUID = -6675192305952590468L;
    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    private String kycSunrateStoreId;

    /**
     * 入账账户号
     */
    private String inAcct;

    /**
     * 入账账户名称
     */
    private String inAcctName;

    /**
     * 出账账户号
     */
    private String outAcct;

    /**
     * 出账账户名称
     */
    private String outAcctName;

    /**
     * '汇付代发明细流水号'
     */
    private String substituteDetailId;

    /**
     * 外部交易单号
     */
    private String tradeNo;

    /**
     * 锁汇流水号
     */
    private String lockNo;

    /**
     * 锁汇交易编号
     */
    private String txnNo;

    /**
     * 寻汇收款虚拟子账户ID
     */
    private String kycSunrateBankId;

    /**
     * 交易类型[0:账户入账,1:账户出账]
     */
    private TradeTypeEnum tradeType;

    /**
     * 交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费]
     */
    private TradeSubTypeEnum tradeSubType;

    /**
     * 操作币种
     */
    private String curId;

    /**
     * 交易金额
     */
    private BigDecimal tradeAmt;

    /**
     * 出账金额
     */
    private BigDecimal outAmt;

    /**
     * 入账金额
     */
    private BigDecimal inAmt;

    /**
     * 账户剩余金额
     */
    private BigDecimal userAcctCurrAmt;

    /**
     * 交易后账户总借款
     */
    private BigDecimal userAcctBorrowAmt;

    private BigDecimal userAcctAvailableAmt;

    private BigDecimal userAcctFrozenAmt;

    /**
     * 交易时间
     */
    private Date tradeDts;

    /**
     * 处理状态
     */
    private ProcessStatusEnum processStatus;

    /**
     * 创建人Id
     */
    @NotBlank(message = "创建人Id不能为空")
    private String createId;

    /**
     * 创建人名称
     */
    @NotBlank(message = "创建人名称不能为空")
    private String createName;
}