package com.js.common.model.req;

import com.js.common.enums.SiteEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySunrateTradeMarketOrderReq implements Serializable {
    private static final long serialVersionUID = -3407546378399826447L;
    /**
     * 锁汇编号
     */
    private String lockNo;
    /**
     * 组织结构代码
     */
    private String orgCode;

    /**
     * 店铺编号
     */
    private String subAcctNo;

    /**
     * 买入币种
     */
    private String buyCur;

    /**
     * 卖出币种
     */
    private String sellCur;
    /**
     * 交易模式
     */
    private String txnMode;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;

    /**
     * 交割日期
     */
    private String valueDate;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 银行卡信息主键ID
     */
    private String kycBankId;

    /**
     * 银行账号
     */
    private String bankNo;

    /**
     * 提交锁汇后虚拟账户可用余额
     */
    private BigDecimal sunrateBankAvailableBalance;

    /**
     * 提交锁汇后虚拟账户余额
     */
    private BigDecimal sunrateBankCurrentBalance;

    /**
     * '批量产生锁汇交易时的批次号
     */
    private String batchNo;

    private TradeTypeEnum tradeType;

    private TradeSubTypeEnum tradeSubType;

    /**
     * 当前客户使用手续费
     */
    private BigDecimal serviceCharge;

    /**
     * 当前客户使用汇率
     */
    private BigDecimal useRate;

    /**
     * 单外币收取汇差值
     */
    private BigDecimal takeRate;

    /**
     * 外币手续费金额
     */
    private BigDecimal chargeAmt;

    private SiteEnum storeTheSite;

    private String jsRemark;

    private BigDecimal refundAmt;
}