package com.js.common.model.req;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySunrateTradeLockPricePreReq implements Serializable {
    private static final long serialVersionUID = 2692369928484118916L;
    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 锁汇表主键ID
     */
    private String lockPriceId;

    /**
     * 寻汇用户表主键ID
     */
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    private String kycSunrateBankId;

    /**
     * 锁汇流水号
     */
    private String transinNoticeId;

    /**
     * 店铺ID
     */
    private String subAcctNo;

    /**
     * 组织结构代码
     */
    private String orgCode;

    /**
     * 买入币种
     */
    private String buyCur;

    /**
     * 买入金额
     */
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    private String sellCur;

    /**
     * 卖出金额
     */
    private BigDecimal sellAmt;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 交易模式
     */
    private String txnMode;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;

    /**
     * 备注
     */
    private String remark;

    /**
     * 交易方式（REPAYMENT-还款，WITHDRAW-提现）
     */
    private TradeTypeEnum tradeType;

    /**
     * 交易子类型
     */
    private TradeSubTypeEnum tradeSubType;

    /**
     * 银行卡信息主键ID
     */
    private String kycBankId;

    /**
     * 银行账号
     */
    private String bankNo;

    private String loanNo;

    /**
     * 提交锁汇后虚拟账户可用余额
     */
    private BigDecimal sunrateBankAvailableBalance;

    /**
     * 当前余额
     */
    private BigDecimal sunrateBankCurrentBalance;

    /**
     * 批量产生锁汇交易时的批次号
     */
    private String batchNo;

    /**
     * 当前客户使用汇率
     */
    private BigDecimal useRate;

    /**
     * 当前客户使用手续费
     */
    private BigDecimal serviceCharge;

    /**
     * 外币手续费金额
     */
    private BigDecimal chargeAmt;

    /**
     * 买入币种手续费金额
     */
    private BigDecimal chargeAmtBuy;

    private BigDecimal refundAmt;

    /**
     * 请求寻汇锁汇交易返回的交易时间
     */
    private Date txnDatetime;

    /**
     * 处理状态
     */
    private ProcessStatusEnum processStatus;

    private String jsRemark;
}