package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class ApplyWithdrawReq implements Serializable{
    private static final long serialVersionUID = -1554709962364051460L;

    /**
     * 店铺Id
     */
    @NotBlank(message = "店铺Id不能为空")
    private String storeId;

    /**
     * 店铺名称
     */
    @NotBlank(message = "店铺名称不能为空")
    private String storeName;

    /**
     * 店铺提现金额
     */
    @NotNull(message = "提现金额不能为空")
    private BigDecimal withdrawAmt;

    /**
     * 提现银行卡Id
     */
    private String bankId;

    /**
     * 提现银行卡号
     */
    private String accountNo;

    /**
     * 银行卡预留手机号
     */
    private String phone;

    /**
     * 客户端浏览器IP
     */
    private String browserIP;

    /**
     * 提交锁汇后虚拟账户可用余额
     */
    private BigDecimal sunrateBankAvailableBalance;

    /**
     * 提交锁汇后虚拟账户余额
     */
    private BigDecimal sunrateBankCurrentBalance;

    /**
     * '批量产生锁汇交易时的批次号
     */
    private String batchNo;

    /**
     * 到账币种
     */
    private String currency;
}