package com.js.common.enums;

import com.js.common.util.DbEnum;
import com.js.common.util.Localisable;
import lombok.Getter;

@Getter
public enum CurrEnum implements DbEnum {
    CURR_CNY("CNY", "人民币","￥"),
    CURR_USD("USD", "美元","$"),
    CURR_EUR("EUR", "欧元","€"),
    CURR_HKD("HKD", "港币","HK$"),
    CURR_GBP("GBP", "英镑","￡"),
    CURR_CAD("CAD", "加元","C$"),
    CURR_JPY("JPY", "日元","¥"),
            ;
    /** 简称 */
    private String enumCode;
    /** 国名 */
    private String enumName;
    /** 币种符号 */
    private String currencySymbol;

    CurrEnum(String enumCode, String enumName,String currencySymbol) {
        this.enumCode = enumCode;
        this.enumName = enumName;
        this.currencySymbol = currencySymbol;
    }

    @Override
    public String queryEnumCode() {
        return this.enumCode;
    }

    @Override
    public String keyName() {
        return this.enumName;
    }


}
