package com.js.common.enums;

/**
 * @Author liuh
 * @Description 实名认证状态常量值
 * @Date 2019/5/25
 **/
public enum CertiStatusEnum {
    NO_SUBMIT(0, "未提交认证信息","等待提交实名信息"),
    FAILURE(2, "认证失败","等待运营沟通"),
    SUCCESS(1, "已认证","实名认证通过"),
    SUBMIT_WATING(3, "认证审核中","等待寻汇审核结果"),
    SUBMIT_FAILURE(4, "调用寻汇返回失败","等待运营人员处理"),
    SUBMIT_FIRST_TRIAL(5, "提交初审","等待后台运营审核处理"),
    FIRST_TRIAL_FAILURE(6, "初审失败","等待客户自己修改实名信息"),
    KYC_INFO_SUBMIT(7, "KYC实名信息提交","等待前端录入股东受益人信息"),
    CONTACTS_AUDIT_FAILURE(8, "最终受益人驳回","等待编辑完善股东受益人信息"),

    AUDIT_PASS(9, "KYC实名反洗钱审核通过","KYC实名反洗钱审核通过"),
    AUDIT_RERUSE(10, "KYC实名反洗钱审核拒绝","KYC实名反洗钱审核拒绝"),
    AUDIT_UNKNOWN(11, "KYC实名反洗钱信息待审核","KYC实名反洗钱信息待审核"),
    ;

    private Integer code;
    private String doDesc;
    private String toDesc;

    CertiStatusEnum(Integer code, String doDesc,String toDesc) {
        this.code = code;
        this.doDesc = doDesc;
        this.toDesc = toDesc;
    }

    public static CertiStatusEnum get(Integer code){
        if(null == code){
            return null;
        }
        for(CertiStatusEnum certiStatusEnum : CertiStatusEnum.values()){
            if(code == certiStatusEnum.getCode()){
                return certiStatusEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDoDesc() {
        return doDesc;
    }

    public String getToDesc() {
        return toDesc;
    }
}
