package com.js.common.util;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.common.model.vo.WaiHuiVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ExchangeUtils {

    public static void main(String args[]){
//        JSONArray waihui = ExchangeUtils.getValue("USD");
//        System.out.println(waihui.toString());
//        Date date = new Date();
//        int m = DateUtil.minute(date);
//        System.out.println(m);
//        System.out.println(m % 3);
//        System.out.println(DateUtil.second(date));
    }

    private final static String idcardcerthost = "https://ali-waihui.showapi.com";
    private final static String path = "/waihui-list";
    private final static String method = "GET";
    private final static String appcode = "a158bfeb333543ac9a0bb964349266c9";

    /**
     * 获取外币兑换信息（人民币兑换）
     * @param currencyCode
     * @return
     */
    public static Map<String,WaiHuiVO> getValue(String currencyCode){
        Map<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        Map<String, String> querys = new HashMap<String, String>();
        if(StringUtils.isNoneBlank(currencyCode)){
            querys.put("code", currencyCode);
        }else {
            querys.put("code", "");
        }
        Map<String,WaiHuiVO> waiHuiVOMap = new HashMap<>();
        try {
            HttpResponse response = AliyunHttpUtils.doGet(idcardcerthost, path, method, headers, querys);
            JSONObject jsonObject = JSON.parseObject(EntityUtils.toString(response.getEntity()));
            if(jsonObject.getIntValue("ret_code") == 0 ){
                JSONArray waihui = jsonObject.getJSONObject("showapi_res_body").getJSONArray("list");
                for(int i = 0 ; i < waihui.size(); i ++){
                    JSONObject jsonObjectDetail = waihui.getJSONObject(i);
                    WaiHuiVO waiHuiVO = new WaiHuiVO();
                    if(StringUtils.isNotBlank(jsonObjectDetail.getString("chao_in"))){
                        waiHuiVO.setChaoIn(jsonObjectDetail.getBigDecimal("chao_in").divide(new BigDecimal(100),4,BigDecimal.ROUND_HALF_UP));
                    }
                    if(StringUtils.isNotBlank(jsonObjectDetail.getString("chao_out"))){
                        waiHuiVO.setChaoOut(jsonObjectDetail.getBigDecimal("chao_out").divide(new BigDecimal(100),4,BigDecimal.ROUND_HALF_UP));
                    }
                    waiHuiVO.setCode(jsonObjectDetail.getString("code"));
                    waiHuiVO.setName(jsonObjectDetail.getString("name"));
                    waiHuiVO.setDay(jsonObjectDetail.getString("day"));
                    waiHuiVO.setTime(jsonObjectDetail.getString("time"));
                    if(StringUtils.isNotBlank(jsonObjectDetail.getString("hui_in"))){
                        waiHuiVO.setHuiIn(jsonObjectDetail.getBigDecimal("hui_in").divide(new BigDecimal(100),4,BigDecimal.ROUND_HALF_UP));
                    }
                    if(StringUtils.isNotBlank(jsonObjectDetail.getString("hui_out"))){
                        waiHuiVO.setHuiOut(jsonObjectDetail.getBigDecimal("hui_out").divide(new BigDecimal(100),4,BigDecimal.ROUND_HALF_UP));
                    }
                    if(StringUtils.isNotBlank(jsonObjectDetail.getString("zhesuan"))){
                        waiHuiVO.setZheSuan(jsonObjectDetail.getBigDecimal("zhesuan").divide(new BigDecimal(100),4,BigDecimal.ROUND_HALF_UP));
                    }
                    waiHuiVO.setPublishDts(DateUtil.parse(waiHuiVO.getDay() + " " + waiHuiVO.getTime(),"yyyy-MM-dd HH:mm:ss"));
                    waiHuiVOMap.put(waiHuiVO.getCode(),waiHuiVO);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return  waiHuiVOMap;
    }
}
