package com.js.common.model.req;

import com.js.common.enums.JsPaySysAcctTypeEnum;
import com.js.common.enums.SysPlateformType;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySysAcctReq implements Serializable {
    /**
     * 平台类型（HFGJ(汇付国际))
     */
    private SysPlateformType plateformType;

    /**
     * 账户类型
     */
    private JsPaySysAcctTypeEnum acctType;


    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 账户名称
     */
    private String acctName;

    /**
     * 账户号
     */
    private String acctNo;

    /**
     * 证件号
     */
    private String idNo;

    /**
     * '收款银行名称'
     */
    private String receivingBankName;

    /**
     * '收款银行地址'
     */
    private String receivingBankAddr;

    /**
     * '收款人地址'
     */
    private String receivingAcctAddr;

    /**
     * 'swiftcode'
     */
    private String swiftCode;

    /**
     * '收款人常驻国家'
     */
    private String receivingAcctCountry;

    /**
     * '收款账户信息'
     */
    private String receivingAcctDesc;

    /**
     * '币种
     */
    private String cur;

    /**
     * 账户余额
     */
    private BigDecimal availableAmt;

    /**
     * 冻结金额
     */
    private BigDecimal frozenAmt;

    /**
     * 昨日余额
     */
    private BigDecimal lastAmt;

    int pageIndex = 0;
    int pageSize = 10;
}