package com.js.common.model.req;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

public class JsPayAddSupplierInfoReq implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 税局国家代码
     */
    private String taxStationCountry;

    /**
     * 银行识别码BIC
     */
    @NotBlank(message = "银行识别码BIC不能为空.")
    private String bankBic;

    /**
     * 银行名称
     */
    @NotBlank(message = "银行名称不能为空.")
    private String bankName;

    /**
     * 银行账户名称
     */
    @NotBlank(message = "账户名称不能为空.")
    private String cusName;

    /**
     * 路由类型，如果 1 和 3 或者 2 和 3 有 2 种方式的话，确认，一个即可 1：aba,2：iban,3：swift
     */
    @NotBlank(message = "路由类型不能为空")
    private String routeType;
    /**
     * 国际银行账号 IBAN
     */
    private String iban;

    /**
     * Sort Code路由号码
     */
    private String sortCode;

}
