package com.js.common.enums;

import java.math.BigDecimal;

/**
 * @Author liuh
 * @Description 店铺所在站点
 * @Date 2019/6/5
 **/
public enum SiteEnum {
    NORTH_AMERICA_SITE(1,"USD","北美站","$","美元",new BigDecimal(0.005),AmazonEndpointEnum.US),
    CANASA_SITE(2,"CAD","加拿大站","C$","加元",new BigDecimal(0.005),AmazonEndpointEnum.CANADA),
    ENGLAND_SITE(3,"GBP","英国站","￡","英镑",new BigDecimal(0.005),AmazonEndpointEnum.UK),
    EUROPE_SITE_FRENCH(4,"EUR","欧洲站-法国","€","欧元",new BigDecimal(0.005),AmazonEndpointEnum.FRANCE),
    EUROPE_SITE_GERMANY(5,"EUR","欧洲站-德国","€","欧元",new BigDecimal(0.005),AmazonEndpointEnum.GERMANY),
    EUROPE_SITE_ITALY(6,"EUR","欧洲站-意大利","€","欧元",new BigDecimal(0.005),AmazonEndpointEnum.ITALY),
    EUROPE_SITE_SPAIN(7,"EUR","欧洲站-西班牙","€","欧元",new BigDecimal(0.005),AmazonEndpointEnum.SPAIN),
    JSPAN_SITE(8,"JPY","日本站","¥","日元",new BigDecimal(0.005),AmazonEndpointEnum.JAPAN),
    ;
    private Integer code;
    private String currency;
    private String siteName;
    /**
     * 币种符号
     */
    private String currencySymbol;
    /**
     * 币种单位
     */
    private String hyDesc;

    //默认手续费比例 - 数据库如果不配置用户手续费则取此默认值
    private BigDecimal jsTradeServiceChargeValue;

    private AmazonEndpointEnum amazonEndpointEnum;

    SiteEnum(Integer code,String currency,String siteName,String currencySymbol,String hyDesc,BigDecimal jsTradeServiceChargeValue,AmazonEndpointEnum amazonEndpointEnum) {
        this.code = code;
        this.currency = currency;
        this.siteName = siteName;
        this.currencySymbol = currencySymbol;
        this.hyDesc = hyDesc;
        this.jsTradeServiceChargeValue = jsTradeServiceChargeValue;
        this.amazonEndpointEnum = amazonEndpointEnum;
    }

    public static SiteEnum getByCurrency(String currency){
        for(SiteEnum siteEnum : SiteEnum.values()){
            if(currency.equals(siteEnum.getCurrency())){
                return siteEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getCurrency() {
        return currency;
    }

    public String getSiteName() {
        return siteName;
    }

    public String getCurrencySymbol() {
        return currencySymbol;
    }

    public String getHyDesc() {
        return hyDesc;
    }

    public BigDecimal getJsTradeServiceChargeValue() {
        return jsTradeServiceChargeValue;
    }

    public AmazonEndpointEnum getAmazonEndpointEnum() {
        return amazonEndpointEnum;
    }
}
