package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 影像文件类型
 * @Author: liuh
 * @Create: 2019-05-18
 **/
@Getter
public enum CertiFileType {
    CARD_FRONT_IMAGE(0, "身份证正面影像"),
    CARD_BACK_IMAGE(1, "身份证反面影像"),
    CARD_HANDID_IMAGE(2, "手持身份证影像"),
    BUSINESS_LICENSE_IMAGE(3, "企业营业执照"),
    ID_CARD(4,"第二代居民身份证"),
    PASSPROT_IMAGE(5, "护照影像"),
    CARD_HK_PERPETUAL(6, "香港永久性居民身份证"),
    CARD_HANDID_HK_PERPETUAL(7, "手持香港永久性居民身份证"),
    UK_PASSPORT(8, "英国国民（海外）护照"),
    BUSI_REGISTERATION_CERTI(9, "商业登记证"),
    COMPANY_REGISTER_CERTI(10, "公司注册证书"),
    OTHER(11, "无类型"),//ORC识别时此类型表示不需要识别
    ;
    /** 编码 */
    private Integer enumCode;
    /** 说明 */
    private String enumName;

    CertiFileType(Integer enumCode, String enumName) {
        this.enumCode = enumCode;
        this.enumName = enumName;
    }
}
