package com.js.common.util;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.*;
import lombok.Getter;
import lombok.Setter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: OSSUtil
 * @Description: OSS 工具类
 * @Author: yjzhao
 * @Create: 2018-12-04  10:40
 **/
@Getter
@Setter
public class OSSUtil {

    private OSSClient ossClient;

    public void uploadByInputStream(String bucket, String fileKey, InputStream inputStream) {
        try {
            ossClient.putObject(bucket, fileKey, inputStream);
        } catch (Exception e){
            e.printStackTrace();
        }
        //return urlFromFileKey(bucket, fileKey);
    }

    /**
     * 上传本地文件
     * @param bucket   Bucket
     * @param filePath 本地文件路径
     * @param fileKey  指定OSS文件名，传空时自动生成UUID
     * @return
     * @throws FileNotFoundException
     */
    public String putObject(String bucket, String filePath, String fileKey) throws FileNotFoundException {
        ossClient.putObject(bucket,  fileKey, new File(filePath));
        return fileKey;
    }

    /**
     * 下载文件到本地目录
     *
     * @param bucket    Bucket
     * @param fileKey   OSS文件名
     * @param localPath 本地文件目录
     * @return
     */
    public String getObject(String bucket, String fileKey, String localPath) {
        String localFileKey = localPath + fileKey;
        ossClient.getObject(new GetObjectRequest(bucket, fileKey), new File(localFileKey));
        return localFileKey;
    }


    /**
     * 检查文件是否存在
     * @param bucket  Bucket
     * @param fileKey OSS文件名
     * @return
     */
    public boolean checkObject(String bucket, String fileKey) {
        return ossClient.doesObjectExist(bucket, fileKey);
    }


    /**
     * 列出所有文件
     * @param bucket    Bucket
     * @param keyPrifix 文件名前缀
     */
    public List<String> listObjects(String bucket, String keyPrifix) {
        List<String> fileList = new ArrayList<>();

        ObjectListing objectListing = ossClient.listObjects(bucket, keyPrifix);
        List<OSSObjectSummary> sums = objectListing.getObjectSummaries();
        for (OSSObjectSummary s : sums) {
            fileList.add(bucket);
        }

        return fileList;
    }

    /**
     * 删除文件
     * @param bucket
     * @param fileKey
     */
    public void deleteObject(String bucket, String fileKey) {
        ossClient.deleteObject(bucket, fileKey);
    }

    /**  获取文件 获取文件流 */
    public InputStream getOSSInputStream(String bucket, String key) {

        OSSObject ossObject = ossClient.getObject(bucket, key);
        return ossObject.getObjectContent();
    }

    /**  复制文件 */
    public boolean copyObject(String bucket, String sourceObjectName, String destinationObjectName) {

        CopyObjectResult result = ossClient.copyObject(bucket, sourceObjectName, bucket, destinationObjectName);

        return true;
    }


}
