package com.js.common.util;


import com.js.common.enums.LogFileEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @ClassName: LoggerUtils
 * @Description: 日志工具类
 * @Author: yjzhao
 * @Create: 2018-12-14  14:11
 **/
public class LoggerUtils {
    public static <T> Logger Logger(Class<T> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    /**
     * 打印到指定的文件下
     *
     * @param desc 日志文件名称
     * @return
     */
    public static Logger Logger(LogFileEnum desc) {
        return LoggerFactory.getLogger(desc.getLoggerName());
    }
}
