package com.js.common.model.vo;

import com.js.common.enums.BankAcctTypeEnum;
import com.js.common.enums.BindingBankCardType;
import com.js.common.enums.SysPlateformType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class KycBankVO implements Serializable {
    private static final long serialVersionUID = 7427594961116821834L;

    private String id;

    /**
     * 注册用户主键 id
     */
    private String kycNaturalId;

    /**
     * 银行卡用户名
     */
    private String accountName;

    /**
     * 账号币种
     */
    private String currencyCode;

    /**
     * 币种名称
     */
    private String currencyDesc;

    /**
     * 银行卡号
     */
    private String accountNo;

    private String idNo;

    private BindingBankCardType bindingType;

    /**
     * 银行卡预留手机号
     */
    private String phone;

    /**
     * 银行卡所属地域
     */
    private String stateOrRegion;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行卡可用渠道
     */
    private SysPlateformType routeType;

    /**
     * 银行编码
     */
    private String bankCode;

    /**
     * 银行所在省份名称
     */
    private String provinceName;

    /**
     * 银行所在市Code
     */
    private String cityCode;

    /**
     * 银行所在市名称
     */
    private String cityName;

    /**
     * 银行支行名称
     */
    private String bankBranchName;

    /**
     * 银行支行行号
     */
    private String bankBranchCode;

    /**
     * 开对公户时账户类型
     */
    private BankAcctTypeEnum companyAcctType;

    /** 创建人名称 */
    private String createName;

    /** 创建日期 */
    private Date createDts;

    /** 更新人名称 */
    private String updateName;

    /** 更新时间 */
    private Date updateDts;

    private Boolean delFlag;
}
