package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsTradeVO implements Serializable {
    private static final long serialVersionUID = 1L;

    private String kycNaturalId;

    /**
     * 外部交易单号
     */
    private String tradeNo;

    /**
     * 账户类型 1.寻汇，2.汇付
     */
    private String accType;

    /**
     * 交易类型[0:账户入账,1:账户出账]
     */
    private String tradeType;

    /**
     * 入账账户号
     */
    private String inAcct;

    /**
     * 入账账户名称
     */
    private String inAcctName;

    /**
     * 出账账户号
     */
    private String outAcct;

    /**
     * 出账账户名称
     */
    private String outAcctName;

    /**
     * 交易子类型[0:子账户入账,1:还款,2:提现,3:提现手续费,4:逾期费,5:vat,6:供应商付款,7:放款]
     */
    private String tradeSubType;

    /**
     * 币种
     */
    private String curId;

    /**
     * 交易金额
     */
    private BigDecimal tradeAmt;

    /**
     * 出账金额
     */
    private BigDecimal outAmt;

    /**
     * 入账金额
     */
    private BigDecimal inAmt;

    /**
     * 交易时间
     */
    private Date tradeDts;

    /**
     * 处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)
     */
    private String processStatus;




}
