package com.js.common.model.vo;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.TradeSubTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsTradeListVO implements Serializable {
    private static final long serialVersionUID = -4565392582128338021L;

    private String tradeId;

    private String batchNo;

    /**
     * 入账通知编号
     */
    private String transinNoticeId;

    /**
     * 交易类型
     */
    private String tradeSubTypeEnumDesc;

    /**
     * 入账时间/提现时间
     */
    private Date tradeDate;

    private String tradeDtsStr;
    /**
     * 平台
     */
    private String storePlateForm;

    /**
     * 平台名称
     */
    private String storePlateFormName;

    /**
     * 站点Code
     */
    private String storeTheSiteCode;

    /**
     * 站点名称
     */
    private String storeTheSiteName;

    /**
     * 平台名称 + 站点名称
     */
    private String plateformAndSite;

    /**
     * 店铺
     */
    private String storeName;
    /**
     * 币种
     */
    private String currency;

    /**
     * 币种描述
     */
    private String currencyDesc;

    /**
     * 金额
     */
    private BigDecimal amt;
    /**
     * 状态
     */
    private ProcessStatusEnum processStatus;
    /**
     * 状态描述
     */
    private String processStatusDes;

    /**
     * 买入币种
     */
    private String buyCurrency;

    /**
     * 买入币种
     */
    private String buyCurrencyDesc;

    /**
     * 实际到账金额
     */
    private BigDecimal actualAmt;

    /**
     * 到账银行账户
     */
    private String bankCardNo;

    /**
     * 提现虚拟银行账号
     */
    private String sunrateBankCardNo;

    /**
     * 虚拟银行表账户名称
     */
    private String sunrateBankCusName;

    /**
     * 结汇汇率
     */
    private BigDecimal useRate;

    /**
     * 应收提现手续费-外币
     */
    private BigDecimal accountsReceivableFee;

    /**
     * 实收提现手续费-外币
     */
    private BigDecimal withdrawFee;

    /**
     * 类型
     */
    private TradeSubTypeEnum tradeSubType;

    /**
     * 银行卡账户名称
     */
    private String accountName;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 店铺表主键ID
     */
    private String kycStoreId;

    /**
     * 寻汇虚拟银行表主键ID
     */
    private String kycSunrateBankId;

    /**
     * 锁汇交易编号
     */
    private String txnNo;

    private String sunrateBankId;
    private BigDecimal currentBalance;
    private BigDecimal availableBalance;
}