package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class JsPaySunrateBankVO implements Serializable {
    private static final long serialVersionUID = -5056285998501512745L;

    private String id;
    /**
     * 组织机构代码
     */
    private String orgCode;

    /**
     * 店铺ID
     */
    private String subAcctNo;

    /**
     * 收款银行所在地区（地区国家代码，如：HK、CN、JP。ISO 3166-1 alpha-2）
     */
    private String bankCountryCode;

    /**
     * 收款银行名称
     */
    private String bankName;

    /**
     * 收款银行地址
     */
    private String bankAddr;

    /**
     * 收款银行账户名称
     */
    private String cusName;

    /**
     * 收款银行账号
     */
    private String bankCardNo;

    /**
     * 当前余额 = 可用余额 + 冻结金额
     */
    private BigDecimal currentBalance;

    /**
     * 可用余额
     */
    private BigDecimal availableBalance;

    /**
     * 昨日余额
     */
    private BigDecimal lastdayBalance;

    /**
     * 冻结余额
     */
    private BigDecimal freezedBalance;

    /**
     * 币种(如：USD)
     */
    private String curId;

    /**
     * 币种(如：USD)
     */
    private String curIdSymbol;

    /**
     * 路由方式
     */
    private String routeType;

    /**
     * aba
     */
    private String aba;

    /**
     * iban
     */
    private String iban;

    /**
     * swiftcode
     */
    private String swiftCode;

    private BigDecimal waitingBookedAmt;
    private String kycNaturalId;
}