package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 借货用户店铺信息。
 * @author liutianyu
 */
@Data
public class JsLoanStatisticsInfoStoreVO implements Serializable {
    private static final long serialVersionUID = 5326325181544453258L;

    // 总月均销售额
    BigDecimal monthlySale;

    // 笔均入账金额
    BigDecimal averageIncome;

    // 平均客单价
    BigDecimal perCustomerTransaction;

    // 月均退款额
    BigDecimal monthlyRefundAmount;

    // 总税率
    BigDecimal taxRate;

    // 平均订单数
    BigDecimal monthlyOrderNum;

    // 平均SKU数量
    BigDecimal averageSkuNum;

    // 店铺名称
    String storeName;

    // 平台名称
    String plateform;

    // 收款账户名
    String accountName;

    // 授权状态
    Integer authStatus;

    // 店铺 id
    String storeId;
}
