package com.js.common.model.req.common;

import lombok.Data;

import java.io.Serializable;

@Data
public class MailReq implements Serializable {
    private static final long serialVersionUID = -5427478962594749326L;

    /**
     * 收信人邮件
     */
    String to;
    /**
     * 邮件标题
     */
    String subject;
    /**
     * 正文件内容
     */
    String content;
    /**
     * 抄送人邮件列表
     */
    String[] cc;
    /**
     * 是否是 html 邮件，如果发送的邮件带附件或资源，需要设为 true
     */
    Boolean htmlFlag = false;
    /**
     * 附件文件路径
     */
    String filePath;
    /**
     * 嵌入邮件的资源路径
     */
    String rscPath;
    /**
     * 嵌入邮件的资源 id
     */
    String rscId;

}
