package com.js.common.model.req;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SunrateTradeMarketOrderReq implements Serializable{
    private static final long serialVersionUID = -1291871639498427489L;
    /**
     *锁汇编号 26 合作方锁汇编号，需保证在合作方不重复
     */
    private String lockNo;
    /**
     * 组织机构代码
     */
    private String orgCode;
    /**
     * 店铺编号
     */
    private String subAcctNo;

    /**
     * 买入币种  如：USD
     */
    private String buyCur;

    /**
     * 卖出币种  如：CNY
     */
    private String sellCur;

    /**
     * 交易模式(0：买入模式,1：卖出模式)
     */
    private String txnMode;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;
    /**
     * 交割日期
     */
    private String valueDate;
    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 客户端浏览器IP
     */
    private String browserIP;
}