package com.js.common.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 代发批次实体
 */
@Data
@ApiModel(value="代发批次实体（ChinaPNRSubstituteReq）",description="代发批次实体")
public class ChinaPNRSubstituteReq implements Serializable {

    private static final long serialVersionUID = -1513703756018851418L;
    /**
     * 用户ID
     */
    @NotBlank(message = "用户ID不能为空")
    @ApiModelProperty(value = "用户ID")
    private String kycNaturalId;

    /**
     * 批次号
     */
    @NotBlank(message = "批次号不能为空")
    @ApiModelProperty(value = "批次号")
    private String batchNo;

    /**
     * 请求流水号
     */
    @ApiModelProperty(value = "请求流水号")
    private String requestId;

    /**
     * 总笔数
     */
    @NotBlank(message = "总笔数不能为空")
    @ApiModelProperty(value = "总笔数")
    private int payTCnt;

    /**
     * 总金额
     */
    @NotBlank(message = "总金额不能为空")
    @ApiModelProperty(value = "总金额")
    private BigDecimal payTAmt;

    /**
     * 到账类型
     */
    @NotBlank(message = "到账类型不能为空")
    @ApiModelProperty(value = "到账类型")
    public String remitType;

    /**
     * 交易币种
     */
    @NotBlank(message = "交易币种不能为空")
    @ApiModelProperty(value = "交易币种")
    private String payCur;



    /**
     * 交易明细
     */
    @NotBlank(message = "交易明细不能为空")
    @ApiModelProperty(value = "交易明细")
    private List<ChinaPNRSubstituteDetails> detailsList;
}
