package com.js.common.enums;

import lombok.Getter;

/**
 * @Description: 处理状态
 * @Author: liuh
 * @Create: 2019-6-12
 **/
@Getter
public enum ProcessStatusEnum {
    TRADE_SUBMITTED(0,"已提交"),
    TRADE_UNPROCESSED(1,"未处理"),
    TRADE_PROCESSED(2, "已处理"),
    TRADE_PROCESSEDING(3,"处理中"),
    TRADE_PROCESSED_FAILURE(4,"处理失败"),
    ;
    /** 编码 */
    private Integer code;
    /** 说明 */
    private String desc;
    ProcessStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
