package com.js.common.JsException;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.js.common.enums.ResultEnum;
import com.js.common.model.resp.ArgumentInvalidResult;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * @ClassName: GlobalExceptionHandler
 * @Description: 异常统一处理
 * @Author: yjzhao
 * @Create: 2019-05-17  11:16
 **/
@Slf4j
@ControllerAdvice
@ResponseBody
public class GlobalExceptionHandler {

    /**
     * @Author yjzhao
     * @Description 校验异常
     * @Date 2019/5/21 13:17
     * @Param [request, exception]
     * @return java.lang.Object
     **/
    @ExceptionHandler(value= MethodArgumentNotValidException.class)
    public Object MethodArgumentNotValidHandler(HttpServletRequest request,
                                                MethodArgumentNotValidException exception) throws Exception {

        //按需重新封装需要返回的错误信息
        List<ArgumentInvalidResult> invalidArguments = new ArrayList<>();
        //解析原错误信息，封装后返回，此处返回非法的字段名称，原始值，错误信息
        for (FieldError error : exception.getBindingResult().getFieldErrors()) {
            ArgumentInvalidResult invalidArgument = new ArgumentInvalidResult();
            invalidArgument.setDefaultMessage(error.getDefaultMessage());
            invalidArgument.setField(error.getField());
            invalidArgument.setRejectedValue(error.getRejectedValue());
            invalidArguments.add(invalidArgument);
        }
//        return ResultUtil.error(invalidArguments, ResultEnum.SYSTEM_ERROR);
        //将原有返回错误方式修改为只返回第一个错误信息
        FieldError fieldError = exception.getBindingResult().getFieldErrors().get(0);
        return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),fieldError.getDefaultMessage());
    }

    /**
     * @Author yjzhao
     * @Description 业务逻辑错误
     * @Date 2019/5/21 13:24
     * @Param [request, e, response]
     * @return java.lang.Object
     **/
    @ExceptionHandler(value = LogicException.class)
    public Object logicExceptionHandler(HttpServletRequest request, Exception e, HttpServletResponse response) {
        //系统级异常，错误码固定为-1，提示语固定为系统繁忙，请稍后再试
        ResponseMessage error = ResultUtil.error(ResultEnum.SYSTEM_ERROR);
        //如果是业务逻辑异常，返回具体的错误码与提示信息
        LogicException logicException = (LogicException) e;
        error.setCode(logicException.getCode());
        error.setMsg(logicException.getErrorMsg());
        return error;

    }

    /**
     * @Author yjzhao
     * @Description 未定义错误
     * @Date 2019/5/21 13:35
     * @Param [request, e, response]
     * @return java.lang.Object
     **/
    @ExceptionHandler(value = Exception.class)
    @ResponseBody
    public Object otherExceptionHandler(HttpServletRequest request, Exception e, HttpServletResponse response) {
        //系统级异常，错误码固定为-1，提示语固定为系统繁忙，请稍后再试
        ResponseMessage error = ResultUtil.error(ResultEnum.SYSTEM_ERROR.getCode(), ResultEnum.SYSTEM_ERROR.getMsg());
            //对系统级异常进行日志记录
        if(StrUtil.isNotBlank(e.getMessage())) {
            error.setData(e.getMessage());
        }
        log.error("系统异常:" + e.getMessage(), e);
        return error;
    }
}
