package com.js.common.util;

import com.alibaba.fastjson.JSON;
import com.js.common.model.vo.common.ResponseMessage;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

/**
 * @Author yjzhao
 * @Description 直接数据响应
 * @Date 2019/5/15 20:34
 * @Param 
 * @return 
 **/
@Slf4j
public class ResponseUtil {

    /**
     *  使用response输出JSON
     * @param response
     * @param responseMessage
     */
    public static void out(HttpServletResponse response, ResponseMessage responseMessage){

        PrintWriter out = null;
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            out = response.getWriter();
            out.println(JSON.toJSON(responseMessage));
        } catch (Exception e) {
            log.error(e + "输出JSON出错");
        }finally{
            if(out!=null){
                out.flush();
                out.close();
            }
        }
    }
}
