package com.js.common.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import org.apache.commons.lang.StringUtils;

public class PinYinUtils {

    public static String getHanziPinYin(String hanzi) {
        String result = null;
        try {
            if (StringUtils.isNotBlank(hanzi)) {
                char[] charArray = hanzi.toCharArray();
                StringBuffer sb = new StringBuffer();
                for (char ch : charArray) {
                    HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
//                    hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
                    hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
                    hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
                    String s = PinyinHelper.toHanYuPinyinString(String.valueOf(ch), hanyuPinyinOutputFormat, "", true);
                    if (StringUtils.isNotBlank(s)) {
                        String eachFirstPinYin = String.valueOf(s.charAt(0));
                        String remainPinYin = s.substring(1);
                        sb.append(eachFirstPinYin.toUpperCase()).append(remainPinYin).append(" ");
                    }
                }
                if (sb.length() > 0) {
                    result = sb.toString().substring(0, sb.length() - 1);
                }
            }
        }catch (Exception ex){
            System.out.println("汉字转换拼音异常" + ex);
        }
        return result;
    }

    public static void main(String[] args){
        System.out.println(PinYinUtils.getHanziPinYin("吕文英"));
    }
}
