package com.js.common.model.vo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySupplierEURVO<T> extends JsPaySupplierVO {
    /**
     * 收款方银行所在地（地区国家代码，如：HK、CN、JP）
     */
    private String rcvBankCountry;
    /**
     * 收款银行名称
     */
    private String rcvBankName;
    /**
     * 路由类型
     */
    private String routeType;
    /**
     * IBAN国际银行账号
     */
    private String iban;
    /**
     * SWIFT/BIC编码
     */
    private String swiftBic;
    /**
     * 银行地址
     */
    private String bankAddr;

    @Override
    public String toString(){
        return  super.toString()+ "rcvBankCard|rcvBankName|sortCode|swiftBic|bankAddr" + endString() ;
    }
}
