package com.js.common.model.vo;

import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.enums.TradeTypeEnum;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class JsPaySunrateTradeLockPriceVO implements Serializable {
    private static final long serialVersionUID = -4304665596957950622L;

    private String id;

    /**
     * 注册信息表主键ID
     */
    private String kycNaturalId;

    /**
     * 寻汇用户表主键ID
     */
    private String kycSunrateStoreId;

    /**
     * 寻汇收款虚拟子账户ID
     */
    private String kycSunrateBankId;

    /**
     * 锁汇流水号
     */
    private String lockNo;

    /**
     * 询价流水号
     */
    private String queryNo;

    /**
     * 锁汇交易编号-Key-寻汇交易唯一编号
     */
    private String txnNo;

    /**
     * 请求锁汇交易方式（TRADE_QUERY_PRICE-询价锁汇，TRADE_MARKET_ORDER-市价锁汇）
     */
    private String requestType;

    /**
     * 店铺ID
     */
    private String subAcctNo;

    /**
     * 组织结构代码
     */
    private String orgCode;

    /**
     * 买入币种
     */
    private String buyCur;

    /**
     * 买入金额
     */
    private BigDecimal buyAmt;

    /**
     * 卖出币种
     */
    private String sellCur;

    /**
     * 卖出金额
     */
    private BigDecimal sellAmt;

    /**
     * 手续费币种
     */
    private String feeCur;

    /**
     * 询价汇率
     */
    private BigDecimal queryRate;

    /**
     * 交割日期
     */
    private String valueDate;

    /**
     * 受益人编号
     */
    private String beneficiaryId;

    /**
     * 手续费金额
     */
    private BigDecimal feeAmt;

    /**
     * 支付总金额
     */
    private BigDecimal payAmt;

    /**
     * 交易模式
     */
    private String txnMode;

    /**
     * 交易金额
     */
    private BigDecimal txnAmt;

    /**
     * 成交汇率
     */
    private BigDecimal finRate;

    /**
     * 交易状态02：交易确认  ， 03：入账已确认 ，  09：出账完成
     */
    private String txnStatus;

    /**
     * 备注
     */
    private String remark;

    private TradeTypeEnum tradeType;

    private TradeSubTypeEnum tradeSubType;

    private String kycBankId;

    private String bankNo;

    /**
     * 当前客户使用手续费
     */
    private BigDecimal serviceCharge;

    /**
     * 外币手续费金额
     */
    private BigDecimal chargeAmt;

    private String batchNo;

    private BigDecimal sunrateBankAvailableBalance;

    private BigDecimal sunrateBankCurrentBalance;

    private ProcessStatusEnum processStatus;

    private BigDecimal useRate;

    private BigDecimal takeRate;

    private BigDecimal rateAmt;

    private BigDecimal chargeAmtBuy;

    private Date txnDatetime;
}