package com.js.common.model.req;

import com.js.common.annotation.Phone;
import com.js.common.model.vo.JsPayVatSubAcctInfoVO;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
public class JsPaySupplierBatReq implements Serializable {
    private static final long serialVersionUID = 1L;

    private String id;

    @NotBlank(message = "本机IP地址不能为空")
    private String browserIP;
    /**
     * 注册信息表主键ID
     */
    @NotBlank(message = "注册信息表主键ID不能为空")
    private String kycNaturalId;

    private String fileResourceId;

    /**
     * 店铺ID
     */
    @NotBlank(message = "店铺编号不能为空.")
    private List<JsPayVatSubAcctInfoVO> subAcctNoInfoList;

    private List<JsPaySupplierInfoReq> paySupplierInfoReqList;
    /**
     * 付款用户姓名
     */
    private String kycNaturalName;

    // 社会组织机构代码
    private String orgCode;

    /** 标识 */
    @NotBlank(message = "请确认标识是否填写.")
    private String markStr;

    /** 手机验证码 */
    @NotBlank(message = "请填写手机验证码")
    @Pattern(regexp = "^[0-9]{6}$" , message = "手机验证码错误")
    private String smsCode;

    /**
     * 银行卡预留手机号
     */
    @NotBlank(message = "银行卡预留手机号不能为空.")
    @Phone
    private String phone;

    private BigDecimal totalAmt;
    private String totalNum;

    /**
     * 支付币种
     */
    private String payCur;

    /**
     * 支付币种
     */
    private String rcvCur;

    private String batchStatus;
}
