package com.js.common.model.req;

import java.io.Serializable;
import java.util.Date;

import com.js.common.enums.*;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class GenerateFileRecordReq implements Serializable {
    @NotBlank(message = "下载ID不能为空")
    private String id;
    /**
     * 注册表主键ID
     */
    private String kycNaturalId;

    /**
     * 生成文件编号
     */
    private String generateNo;

    /**
     * 生成类型（GENERATE_TRADE_RECORD-下载交易记录，GENERATE_TRADE_RECEIPT-下载回执单，GENERATE_FUND_RECORD-下载资金记录）
     */
    @NotNull(message = "下载类型不能为空")
    private GenerateFileType generateType;

    /**
     * 生成起始日期
     */
    private Date generateStartDate;

    /**
     * 生成结束日期
     */
    private Date generateEndDate;

    /**
     * js文件资源表主键ID
     */
    private String commFileId;

    /**
     * '存放路径'
     */
    private String fileSavePath;

    /**
     * '显示名称'
     */
    private String fileShowName;

    /**
     * '下载文件类型'
     */
    private FileType fileType;

    /**
     * '平台'
     */
    private StorePlateformEnum storePlateform;

    /**
     * ''店铺ID''
     */
    private String kycStoreId;

    private String storeName;

    /**
     * '语言类型'
     */
    private LanguageType languageType;

    /**
     * 入账处理状态(TRADE_UNPROCESSED-生成中，TRADE_PROCESSED-生成完成)
     */
    private ProcessStatusEnum processStatus;

    /**
     * '''交易类型'''
     */
    private TradeTypeEnum tradeType;

    /**
     * '账号'
     */
    private String acctNo;

    /**
     * '平台名称'
     */
    private String storePlateformName;
}