package com.js.common.enums;

/**
 * 亚马逊各地区端口
 *
 * 数据主要取自：http://docs.developer.amazonservices.com/en_US/dev_guide/DG_Endpoints.html
 */
public enum AmazonEndpointEnum {
    BRAZIL("Brazil", "BR","BRL", "https://mws.amazonservices.com", "A2Q3Y263D00KWC"
            , "", "", ""),
    CANADA("Canada", "CA","CAD", "https://mws.amazonservices.ca", "A2EUQ1WTGCTBG2",
            "AKIAIR5WCWIJRYUJGVYQ", "rY7uMp7S5v0c3gaUVkKk721fBmsVRAHZQW6hAoaP", "Amazon.ca"),
    MEXICO("Mexico", "MX", "MXN","https://mws.amazonservices.com.mx", "A1AM78C64UM0Y8",
            "AKIAIR5WCWIJRYUJGVYQ", "rY7uMp7S5v0c3gaUVkKk721fBmsVRAHZQW6hAoaP", "Amazon.com.mx"),
    US("US", "US", "USD","https://mws.amazonservices.com", "ATVPDKIKX0DER",
            "AKIAIR5WCWIJRYUJGVYQ", "rY7uMp7S5v0c3gaUVkKk721fBmsVRAHZQW6hAoaP", "Amazon.com"),
    UNITED_ARAB_EMIRATES ("UnitedArabEmirates", "AE","AED", "https://mws.amazonservices.ae", "A2VIGQ35RCS4UG",
            "", "", ""),
    GERMANY("Germany", "DE","EUR", "https://mws-eu.amazonservices.com", "A1PA6795UKMFR9",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.de"),
    SPAIN("Spain", "ES", "EUR","https://mws-eu.amazonservices.com", "A1RKKUPIHCS9HS",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.es"),
    FRANCE("France", "FR", "EUR","https://mws-eu.amazonservices.com", "A13V1IB3VIYZZH",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.fr"),
    UK("UK", "GB", "GBP","https://mws-eu.amazonservices.com", "A1F83G8C2ARO7P",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.co.uk"),
    INDIA("India", "IN","INR", "https://mws.amazonservices.in", "A21TJRUUN4KGV",
            "", "", ""),
    ITALY("Italy", "IT","EUR", "https://mws-eu.amazonservices.com", "APJ6JRA9NG5V4",
            "AKIAJJP6XSDHDHZWJIGA", "sdU/cq6RSLUH9B2zQE2jjnRe8rblpePax0Zu0C3V", "Amazon.it"),
    TURKEY("Turkey", "TR","TL", "https://mws-eu.amazonservices.com", "A33AVAJ2PDY3EV",
            "", "", ""),
    AUSTRALIA("Australia", "AU","AUD", "https://mws.amazonservices.com.au", "A39IBJ37TRP1C6",
            "", "", ""),
    JAPAN("Japan", "JP","JPY", "https://mws.amazonservices.jp", "A1VC38T7YXB528",
            "AKIAJQEPHR5DFUMQSHAA", "L5+FXpjhWhWa7C3uxYFjs7JB/kx8ZBv3FP9BGsP7", "Amazon.co.jp"),
    CHINA("China", "CN","CNY", "https://mws.amazonservices.com.cn", "AAHKV2X7AFYLW",
            "", "", "");

    /**
     * 市场
     */
    String marketplace;
    /**
     * 国家代码
     */
    String countryCode;

    /**
     * 国家代码
     */
    String currencyCode;
    /**
     * 服务接口地址
     */
    String endpoint;
    /**
     * 市场 code
     */
    String marketPlaceId;
    /**
     * 开发者 key
     */
    String accessKey;
    /**
     * 开发者密钥
     */
    String secrectKey;
    /**
     * 市场名称
     */
    String marketplaceName;

    AmazonEndpointEnum(String marketplace, String countryCode, String currencyCode,String endpoint, String marketPlaceId, String accessKey,
                       String secrectKey, String marketplaceName) {
        this.marketplace = marketplace;
        this.countryCode = countryCode;
        this.currencyCode = currencyCode;
        this.endpoint = endpoint;
        this.marketPlaceId = marketPlaceId;
        this.accessKey = accessKey;
        this.secrectKey = secrectKey;
        this.marketplaceName = marketplaceName;
    }

    public String getMarketplace() {
        return marketplace;
    }

    public String getCountryCode() {
        return countryCode;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public String getMarketPlaceId() {
        return marketPlaceId;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public String getSecrectKey() {
        return secrectKey;
    }

    public String getMarketplaceName() {
        return marketplaceName;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }
}
